/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.utils;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.api.codec.ZCrystal;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class GlowHandler {
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] FIRE = new float[]{1.0f, 0.3f, 0.2f, 1.0f};
    private static final float[] WATER = new float[]{0.3f, 0.6f, 1.0f, 1.0f};
    private static final float[] GRASS = new float[]{0.3f, 1.0f, 0.4f, 1.0f};
    private static final float[] ELECTRIC = new float[]{1.0f, 1.0f, 0.3f, 1.0f};
    private static final float[] ICE = new float[]{0.6f, 0.9f, 1.0f, 1.0f};
    private static final float[] FIGHTING = new float[]{0.8f, 0.3f, 0.2f, 1.0f};
    private static final float[] POISON = new float[]{0.7f, 0.3f, 0.8f, 1.0f};
    private static final float[] GROUND = new float[]{0.8f, 0.65f, 0.4f, 1.0f};
    private static final float[] FLYING = new float[]{0.7f, 0.7f, 1.0f, 1.0f};
    private static final float[] PSYCHIC = new float[]{1.0f, 0.4f, 0.7f, 1.0f};
    private static final float[] BUG = new float[]{0.6f, 0.8f, 0.2f, 1.0f};
    private static final float[] ROCK = new float[]{0.7f, 0.6f, 0.4f, 1.0f};
    private static final float[] GHOST = new float[]{0.6f, 0.5f, 0.9f, 1.0f};
    private static final float[] DRAGON = new float[]{0.5f, 0.4f, 1.0f, 1.0f};
    private static final float[] DARK = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
    private static final float[] STEEL = new float[]{0.7f, 0.75f, 0.8f, 1.0f};
    private static final float[] FAIRY = new float[]{1.0f, 0.6f, 0.9f, 1.0f};
    private static final float[] NORMAL = new float[]{0.9f, 0.9f, 0.9f, 1.0f};

    public static void applyDynamaxGlow(@Nullable PokemonEntity pokemonEntity) {
        if (pokemonEntity == null) {
            return;
        }
        class_1937 class_19372 = pokemonEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_124 teamColour;
            String teamName;
            class_3218 serverLevel = (class_3218)class_19372;
            pokemonEntity.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
            class_2995 scoreboard = serverLevel.method_14170();
            if (pokemonEntity.getPokemon().getSpecies().getName().equalsIgnoreCase("calyrex")) {
                teamName = "glow_dynamax_blue";
                teamColour = class_124.field_1078;
            } else {
                teamName = "glow_dynamax_red";
                teamColour = class_124.field_1061;
            }
            class_268 team = scoreboard.method_1153(teamName);
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(teamColour);
            }
            scoreboard.method_1172(pokemonEntity.method_5820(), team);
        }
    }

    public static void applyTeraGlow(PokemonEntity pokemon, String aspect) {
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            pokemon.method_6092(new class_1293(class_1294.field_5912, Integer.MAX_VALUE, 0, false, false));
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_tera_" + pokemon.getPokemon().getTeraType().showdownId();
            class_268 team = scoreboard.method_1153(teamName);
            class_124 color = GlowHandler.getFormattingForColor(aspect);
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }
            scoreboard.method_1172(pokemon.method_5820(), team);
        }
    }

    public static void applyZGlow(PokemonEntity pokemon, ZCrystal zCrystal) {
        class_1937 class_19372 = pokemon.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            pokemon.method_6092(new class_1293(class_1294.field_5912, 140, 0, false, false));
            class_2995 scoreboard = serverLevel.method_14170();
            String teamName = "glow_type_" + zCrystal.color().toLowerCase(Locale.ROOT);
            class_268 team = scoreboard.method_1153(teamName);
            class_124 color = GlowHandler.getGlowForColor(zCrystal.color());
            if (team == null) {
                team = scoreboard.method_1171(teamName);
                team.method_1141(color);
            }
            scoreboard.method_1172(pokemon.method_5820(), team);
        }
    }

    private static class_124 getFormattingForColor(String color) {
        return switch (color) {
            case "red" -> class_124.field_1061;
            case "blue" -> class_124.field_1078;
            case "green" -> class_124.field_1060;
            case "yellow" -> class_124.field_1054;
            case "brown" -> class_124.field_1079;
            case "light_blue" -> class_124.field_1075;
            case "purple" -> class_124.field_1058;
            case "magenta" -> class_124.field_1076;
            case "black" -> class_124.field_1074;
            case "gray" -> class_124.field_1080;
            case "lime" -> class_124.field_1077;
            case "indigo" -> class_124.field_1064;
            case "tan" -> class_124.field_1063;
            default -> class_124.field_1068;
        };
    }

    private static class_124 getGlowForColor(String color) {
        if (color == null) {
            return class_124.field_1068;
        }
        return switch (color.toLowerCase()) {
            case "black" -> class_124.field_1074;
            case "dark_blue" -> class_124.field_1058;
            case "dark_green" -> class_124.field_1077;
            case "dark_aqua" -> class_124.field_1062;
            case "dark_red" -> class_124.field_1079;
            case "dark_purple" -> class_124.field_1064;
            case "gold" -> class_124.field_1065;
            case "gray" -> class_124.field_1080;
            case "dark_gray" -> class_124.field_1063;
            case "blue" -> class_124.field_1078;
            case "green" -> class_124.field_1060;
            case "aqua" -> class_124.field_1075;
            case "red" -> class_124.field_1061;
            case "light_purple" -> class_124.field_1076;
            case "yellow" -> class_124.field_1054;
            default -> class_124.field_1068;
        };
    }

    public static float[] getTeraColor(String teraId) {
        if (teraId == null) {
            return WHITE;
        }
        return switch (teraId) {
            case "msd:tera_fire" -> FIRE;
            case "msd:tera_water" -> WATER;
            case "msd:tera_grass" -> GRASS;
            case "msd:tera_electric" -> ELECTRIC;
            case "msd:tera_ice" -> ICE;
            case "msd:tera_fighting" -> FIGHTING;
            case "msd:tera_poison" -> POISON;
            case "msd:tera_ground" -> GROUND;
            case "msd:tera_flying" -> FLYING;
            case "msd:tera_psychic" -> PSYCHIC;
            case "msd:tera_bug" -> BUG;
            case "msd:tera_rock" -> ROCK;
            case "msd:tera_ghost" -> GHOST;
            case "msd:tera_dragon" -> DRAGON;
            case "msd:tera_dark" -> DARK;
            case "msd:tera_steel" -> STEEL;
            case "msd:tera_fairy" -> FAIRY;
            case "msd:tera_normal" -> NORMAL;
            default -> WHITE;
        };
    }
}

