/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.fabric.datapack;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.api.types.tera.elemental.ElementalTypeTeraType;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownService;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.github.yajatkaul.mega_showdown.datapack.CustomTypeRegistry;
import com.github.yajatkaul.mega_showdown.mixin.TeraTypesAccessor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Map;
import kotlin.Unit;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import org.jetbrains.annotations.NotNull;

public class CustomTypeRegistryFabric
implements JsonDataRegistry<CustomTypeData> {
    public static final CustomTypeRegistryFabric INSTANCE = new CustomTypeRegistryFabric();
    private final SimpleObservable<CustomTypeRegistryFabric> observable = new SimpleObservable();

    private CustomTypeRegistryFabric() {
    }

    @NotNull
    public class_2960 getId() {
        return class_2960.method_60655((String)"mega_showdown", (String)"mega_showdown/custom_type");
    }

    @NotNull
    public class_3264 getType() {
        return class_3264.field_14190;
    }

    @NotNull
    public Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    @NotNull
    public TypeToken<CustomTypeData> getTypeToken() {
        return TypeToken.get(CustomTypeData.class);
    }

    @NotNull
    public String getResourcePath() {
        return "mega_showdown/custom_type";
    }

    @NotNull
    public SimpleObservable<CustomTypeRegistryFabric> getObservable() {
        return this.observable;
    }

    public void sync(@NotNull class_3222 player) {
    }

    public void reload(@NotNull Map<class_2960, ? extends CustomTypeData> data) {
        CustomTypeRegistry.customTypes.clear();
        data.forEach((identifier, typeData) -> {
            try {
                ElementalType newType = ElementalTypes.register((ElementalType)new ElementalType(typeData.name, class_2561.method_43471((String)typeData.lang), typeData.hue, 0, class_2960.method_60655((String)"cobblemon", (String)"ui/types.png"), typeData.id));
                CustomTypeRegistry.customTypes.put(newType.getShowdownId(), newType);
                ElementalTypeTeraType newTeraType = new ElementalTypeTeraType(newType);
                TeraTypesAccessor.getTypes().put(MiscUtilsKt.cobblemonResource((String)typeData.id), (TeraType)newTeraType);
                Cobblemon.INSTANCE.getShowdownThread().queue(showdownService -> {
                    if (showdownService instanceof GraalShowdownService) {
                        GraalShowdownService service = (GraalShowdownService)showdownService;
                        Value receiveNewTypeDataFn = service.context.getBindings("js").getMember("receiveNewTypeData");
                        receiveNewTypeDataFn.execute(new Object[]{typeData.name, typeData.maxTypeMove, typeData.zTypeMove});
                    }
                    return Unit.INSTANCE;
                });
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Error loading custom type {}: {}", identifier, (Object)e.getMessage());
            }
        });
        Cobblemon.LOGGER.info("Loaded {} custom elemental types", (Object)CustomTypeRegistry.customTypes.size());
        this.observable.emit((Object[])new CustomTypeRegistryFabric[]{this});
    }

    public static class CustomTypeData {
        public String name;
        public String id;
        public int hue;
        public String lang;
        public String zTypeMove;
        public String maxTypeMove;

        public CustomTypeData(String name, String id, int hue, String text, String zTypeMove, String maxTypeMove) {
            this.name = name;
            this.id = id;
            this.hue = hue;
            this.lang = text;
            this.zTypeMove = zTypeMove;
            this.maxTypeMove = maxTypeMove;
        }
    }
}

