/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.components;

import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public record InventoryStorage(class_2487 tag, int count) {
    public static final Codec<InventoryStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2487.field_25128.fieldOf("tag").forGetter(InventoryStorage::tag), (App)Codec.INT.fieldOf("count").forGetter(InventoryStorage::count)).apply((Applicative)instance, InventoryStorage::new));

    public static InventoryStorage defaultStorage(int count) {
        return new InventoryStorage(new class_2487(), count);
    }

    public InventoryStorage save(class_7225.class_7874 registryAccess, class_1277 inventory) {
        if (registryAccess == null) {
            MegaShowdown.LOGGER.error("Registry Access is null during serialization");
            return new InventoryStorage(new class_2487(), this.count);
        }
        class_2487 tag = new class_2487();
        class_2499 itemsList = new class_2499();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_2487 entry = new class_2487();
            entry.method_10567("Slot", (byte)i);
            class_2520 encodedStack = stack.method_57358(registryAccess);
            entry.method_10566("Item", encodedStack);
            itemsList.add((Object)entry);
        }
        tag.method_10566("Items", (class_2520)itemsList);
        return new InventoryStorage(tag, this.count);
    }

    public class_1277 getInventory(class_7225.class_7874 registryAccess) {
        if (registryAccess == null) {
            MegaShowdown.LOGGER.error("Registry Access is null deserialization");
            return new class_1277(1);
        }
        class_1277 inventory = new class_1277(this.count);
        class_2499 itemsList = this.tag.method_10554("Items", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            class_2487 entry = itemsList.method_10602(i);
            int slot = entry.method_10571("Slot") & 0xFF;
            class_2487 itemTag = entry.method_10562("Item");
            Optional optionalStack = class_1799.method_57360((class_7225.class_7874)registryAccess, (class_2520)itemTag);
            optionalStack.ifPresent(stack -> {
                if (!stack.method_7960() && slot < inventory.method_5439()) {
                    inventory.method_5447(slot, stack);
                }
            });
        }
        return inventory;
    }
}

