/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.block.block_entity;

import com.github.yajatkaul.mega_showdown.block.MegaShowdownBlockEntities;
import com.github.yajatkaul.mega_showdown.block.custom.ReassemblyUnitBlock;
import java.util.Locale;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class ReassemblyUnitBlockEntity
extends class_2586 {
    private int cookTime = 0;
    private int maxCookTime = -1;
    private ReassembleStage stage = ReassembleStage.IDLE;

    public ReassemblyUnitBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)MegaShowdownBlockEntities.REASSEMBLY_UNIT_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, ReassemblyUnitBlockEntity be) {
        if (level.field_9236) {
            return;
        }
        if (be.isCooking()) {
            ++be.cookTime;
        }
        if (be.cookTime >= be.maxCookTime && be.maxCookTime > 0) {
            ReassembleStage finishedStage;
            be.stage = finishedStage = (switch (be.stage.ordinal()) {
                case 1 -> ReassembleStage.FINISHED_10;
                case 2 -> ReassembleStage.FINISHED_50;
                case 3 -> ReassembleStage.FINISHED_100;
                default -> ReassembleStage.IDLE;
            });
            be.maxCookTime = -1;
            be.cookTime = 0;
            level.method_8652(pos, (class_2680)state.method_11657(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)finishedStage)), 3);
            class_2680 upperState = level.method_8320(pos.method_10084());
            if (upperState.method_26204() instanceof ReassemblyUnitBlock) {
                level.method_8652(pos.method_10084(), (class_2680)upperState.method_11657(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)finishedStage)), 3);
            }
            ReassemblyUnitBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    public void startProcess(ReassembleStage stage, int durationTicks) {
        this.stage = stage;
        this.cookTime = 0;
        this.maxCookTime = durationTicks;
        if (this.field_11863 != null) {
            class_2338 lowerPos = this.field_11867;
            class_2338 upperPos = lowerPos.method_10084();
            class_2680 lowerState = this.field_11863.method_8320(lowerPos);
            this.field_11863.method_8652(lowerPos, (class_2680)lowerState.method_11657(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage)), 3);
            class_2680 upperState = this.field_11863.method_8320(upperPos);
            if (upperState.method_26204() instanceof ReassemblyUnitBlock) {
                this.field_11863.method_8652(upperPos, (class_2680)upperState.method_11657(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage)), 3);
            }
        }
    }

    public boolean isIdle() {
        return this.stage == ReassembleStage.IDLE;
    }

    public boolean isCooking() {
        return this.stage == ReassembleStage.COOKING_10 || this.stage == ReassembleStage.COOKING_50 || this.stage == ReassembleStage.COOKING_100;
    }

    public boolean isFinished() {
        return this.stage == ReassembleStage.FINISHED_10 || this.stage == ReassembleStage.FINISHED_50 || this.stage == ReassembleStage.FINISHED_100;
    }

    public ReassembleStage getStage() {
        return this.stage;
    }

    public void setStage(ReassembleStage stage) {
        this.stage = stage;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_2680 upperState;
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 lowerPos = this.method_11016();
            class_2338 upperPos = lowerPos.method_10084();
            class_2680 lowerState = serverLevel.method_8320(lowerPos);
            if (lowerState.method_26204() instanceof ReassemblyUnitBlock) {
                class_2680 newLowerState = (class_2680)lowerState.method_11657(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage));
                serverLevel.method_8652(lowerPos, newLowerState, 3);
            }
            if ((upperState = serverLevel.method_8320(upperPos)).method_26204() instanceof ReassemblyUnitBlock) {
                class_2680 newUpperState = (class_2680)upperState.method_11657(ReassemblyUnitBlock.REASSEMBLE_STAGE, (Comparable)((Object)stage));
                serverLevel.method_8652(upperPos, newUpperState, 3);
            }
            ReassemblyUnitBlockEntity.method_31663((class_1937)serverLevel, (class_2338)lowerPos, (class_2680)this.method_11010());
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10569("CookTime", this.cookTime);
        tag.method_10569("MaxCookTime", this.maxCookTime);
        tag.method_10582("Stage", this.stage.name());
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.cookTime = tag.method_10550("CookTime");
        this.maxCookTime = tag.method_10550("MaxCookTime");
        this.stage = ReassembleStage.valueOf(tag.method_10558("Stage"));
    }

    public static enum ReassembleStage implements class_3542
    {
        IDLE,
        COOKING_10,
        COOKING_50,
        COOKING_100,
        FINISHED_10,
        FINISHED_50,
        FINISHED_100;


        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

