/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.battle.effect;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.github.yajatkaul.mega_showdown.battle.effect.AbstractFieldHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9679;
import org.jetbrains.annotations.Nullable;

public class TerrainEffect
extends AbstractFieldHandler {
    public static void handleTerrain(PokemonBattle battle, String terrainName, int ticks) {
        ElementalType type = TerrainEffect.getTypeForTerrain(terrainName);
        if (type == null) {
            return;
        }
        ArrayList<class_243> pokemonPositions = new ArrayList<class_243>();
        class_3218 level = null;
        for (ActiveBattlePokemon pokemon : battle.getActivePokemon()) {
            if (pokemon.getPosition() == null) continue;
            pokemonPositions.add((class_243)pokemon.getPosition().getSecond());
            level = (class_3218)pokemon.getPosition().getFirst();
        }
        if (pokemonPositions.isEmpty() || level == null) {
            return;
        }
        class_243 centre = pokemonPositions.stream().reduce(class_243.field_1353, class_243::method_1019).method_1021(1.0 / (double)pokemonPositions.size());
        double maxDistance = 0.0;
        for (class_243 position : pokemonPositions) {
            for (class_243 otherPosition : pokemonPositions) {
                if (!(position.method_1022(otherPosition) > maxDistance)) continue;
                maxDistance = position.method_1022(otherPosition);
            }
        }
        maxDistance += 2.0;
        List<class_3222> players = Stream.concat(battle.getPlayers().stream(), battle.getSpectators().stream().map(arg_0 -> ((class_3218)level).method_18470(arg_0)).filter(player -> player instanceof class_3222).map(player -> (class_3222)player)).toList();
        int i = 1;
        while ((double)i <= maxDistance) {
            TerrainEffect.createTerrainRing(level, players, centre, i, type);
            ++i;
        }
    }

    @Nullable
    private static ElementalType getTypeForTerrain(String terrain) {
        return switch (terrain) {
            case "mistyterrain" -> ElementalTypes.FAIRY;
            case "electricterrain" -> ElementalTypes.ELECTRIC;
            case "grassyterrain" -> ElementalTypes.GRASS;
            case "psychicterrain" -> ElementalTypes.PSYCHIC;
            default -> null;
        };
    }

    private static void createTerrainRing(class_3218 level, List<class_3222> viewers, class_243 centre, double distance, ElementalType type) {
        for (float i = 0.0f; i < (float)Math.PI * 2; i += (float)Math.PI / (8.0f * (float)distance)) {
            class_243 particlePos = centre.method_1031((double)class_3532.method_15362((float)i) * distance, 0.0, (double)class_3532.method_15374((float)i) * distance);
            viewers.forEach(viewer -> level.method_14166(viewer, (class_2394)TerrainEffect.getDustParticleForType(type, 1.5f), false, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0));
        }
    }

    static class_9679 getDustParticleForType(ElementalType type, float scale) {
        return new class_2390(class_243.method_24457((int)type.getHue()).method_46409(), scale);
    }
}

