/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.api.codec;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public record Conditions(Forms form, Aspects aspect, Abilities ability, Moves moves, Friendship friendship, List<String> aspects, Optional<String> pokemonProperties) {
    public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Forms.CODEC.optionalFieldOf("form", (Object)Forms.DEFAULT()).forGetter(Conditions::form), (App)Aspects.CODEC.optionalFieldOf("aspect", (Object)Aspects.DEFAULT()).forGetter(Conditions::aspect), (App)Abilities.CODEC.optionalFieldOf("ability", (Object)Abilities.DEFAULT()).forGetter(Conditions::ability), (App)Moves.CODEC.optionalFieldOf("move", (Object)Moves.DEFAULT()).forGetter(Conditions::moves), (App)Friendship.CODEC.optionalFieldOf("friendship", (Object)Friendship.DEFAULT()).forGetter(Conditions::friendship), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("aspects", List.of()).forGetter(Conditions::aspects), (App)Codec.STRING.optionalFieldOf("pokemon_properties").forGetter(Conditions::pokemonProperties)).apply((Applicative)instance, Conditions::new));

    public static Conditions DEFAULT() {
        return new Conditions(Forms.DEFAULT(), Aspects.DEFAULT(), Abilities.DEFAULT(), Moves.DEFAULT(), Friendship.DEFAULT(), List.of(), Optional.empty());
    }

    public boolean validate(Pokemon pokemon) {
        if (!this.form.validate(pokemon)) {
            return false;
        }
        if (!this.aspect.validate(pokemon)) {
            return false;
        }
        if (!this.moves.validate(pokemon)) {
            return false;
        }
        if (!this.friendship.validate(pokemon)) {
            return false;
        }
        return this.ability.validate(pokemon);
    }

    public record Forms(List<String> required_forms, List<String> blacklist_forms) {
        public static final Codec<Forms> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).optionalFieldOf("required_forms", List.of()).forGetter(Forms::required_forms), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("blacklist_forms", List.of()).forGetter(Forms::blacklist_forms)).apply((Applicative)instance, Forms::new));

        public static Forms DEFAULT() {
            return new Forms(List.of(), List.of());
        }

        public boolean validate(Pokemon pokemon) {
            if (!this.blacklist_forms.isEmpty() && this.blacklist_forms.contains(pokemon.getForm().getName())) {
                return false;
            }
            return this.required_forms.isEmpty() || this.required_forms.contains(pokemon.getForm().getName());
        }
    }

    public record Aspects(List<List<String>> required_aspects, List<List<String>> blacklist_aspects) {
        public static final Codec<Aspects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("required_aspects", List.of()).forGetter(Aspects::required_aspects), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("blacklist_aspects", List.of()).forGetter(Aspects::blacklist_aspects)).apply((Applicative)instance, Aspects::new));

        public static Aspects DEFAULT() {
            return new Aspects(List.of(), List.of());
        }

        public boolean validate(Pokemon pokemon) {
            if (!this.blacklist_aspects.isEmpty() && this.blacklist_aspects.stream().anyMatch(group -> pokemon.getAspects().containsAll((Collection<?>)group))) {
                return false;
            }
            return this.required_aspects.isEmpty() || this.required_aspects.stream().anyMatch(group -> pokemon.getAspects().containsAll((Collection<?>)group));
        }
    }

    public record Abilities(List<String> required_abilities, List<String> blacklist_abilities) {
        public static final Codec<Abilities> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).optionalFieldOf("required_abilities", List.of()).forGetter(Abilities::required_abilities), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("blacklist_abilities", List.of()).forGetter(Abilities::blacklist_abilities)).apply((Applicative)instance, Abilities::new));

        public static Abilities DEFAULT() {
            return new Abilities(List.of(), List.of());
        }

        public boolean validate(Pokemon pokemon) {
            if (!this.blacklist_abilities.isEmpty() && this.blacklist_abilities.contains(pokemon.getAbility().getName())) {
                return false;
            }
            return this.required_abilities.isEmpty() || this.required_abilities.contains(pokemon.getAbility().getName());
        }
    }

    public record Moves(List<List<String>> required_moves, List<List<String>> blacklist_moves) {
        public static final Codec<Moves> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("required_moves", List.of()).forGetter(Moves::required_moves), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("blacklist_moves", List.of()).forGetter(Moves::blacklist_moves)).apply((Applicative)instance, Moves::new));

        public static Moves DEFAULT() {
            return new Moves(List.of(), List.of());
        }

        public boolean validate(Pokemon pokemon) {
            if (this.blacklist_moves.isEmpty() && this.required_moves.isEmpty()) {
                return true;
            }
            Set moveNames = pokemon.getMoveSet().getMoves().stream().map(Move::getName).collect(Collectors.toSet());
            if (!this.blacklist_moves.isEmpty()) {
                if (this.blacklist_moves.stream().anyMatch(moveNames::containsAll)) {
                    return false;
                }
            }
            if (!this.required_moves.isEmpty()) {
                return this.required_moves.stream().anyMatch(moveNames::containsAll);
            }
            return true;
        }
    }

    public record Friendship(Integer min_friendship, Integer max_friendship) {
        public static final Codec<Friendship> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min_friendship", (Object)0).forGetter(Friendship::min_friendship), (App)Codec.INT.optionalFieldOf("max_friendship", (Object)255).forGetter(Friendship::max_friendship)).apply((Applicative)instance, Friendship::new));

        public static Friendship DEFAULT() {
            return new Friendship(0, 255);
        }

        public boolean validate(Pokemon pokemon) {
            return pokemon.getFriendship() >= this.min_friendship && pokemon.getFriendship() <= this.max_friendship;
        }
    }
}

