/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.google.common.collect.ImmutableList;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public record AccessoryItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final AccessoryItemAttributeModifiers EMPTY = new AccessoryItemAttributeModifiers(List.of(), true);
    public static final Endec<AccessoryItemAttributeModifiers> ENDEC = StructEndecBuilder.of((StructField)Entry.ENDEC.listOf().fieldOf("modifiers", AccessoryItemAttributeModifiers::modifiers), (StructField)Endec.BOOLEAN.optionalFieldOf("show_in_tooltip", AccessoryItemAttributeModifiers::showInTooltip, (Object)true), AccessoryItemAttributeModifiers::new);

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasModifier(class_6880<class_1320> holder, class_2960 location) {
        return this.getModifier(holder, location) != null;
    }

    @Nullable
    public class_1322 getModifier(class_6880<class_1320> holder, class_2960 location) {
        for (Entry entry : this.modifiers) {
            if (!entry.attribute.equals(holder) || !entry.modifier.comp_2447().equals((Object)location)) continue;
            return entry.modifier();
        }
        return null;
    }

    public AccessoryItemAttributeModifiers withModifierAddedForAny(class_6880<class_1320> holder, class_1322 attributeModifier, String slotName, boolean isStackable) {
        return this.withModifierAdded(holder, attributeModifier, "any", isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAdded(class_6880<class_1320> holder, class_1322 attributeModifier, String slotName, boolean isStackable) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            if (!entry.modifier.comp_2447().equals((Object)attributeModifier.comp_2447())) {
                builder.add(entry);
            }
        });
        builder.add((Object)new Entry(holder, attributeModifier, slotName, isStackable));
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    public AccessoryItemAttributeModifiers withoutModifier(class_6880<class_1320> holder, class_2960 location) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            if (entry.modifier.comp_2447().equals((Object)location) && entry.attribute().equals((Object)holder)) {
                return;
            }
            builder.add(entry);
        });
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    public AccessoryAttributeBuilder gatherAttributes(SlotReference slotReference) {
        return this.gatherAttributes(slotReference, null);
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder gatherAttributes(SlotReference slotReference, @Nullable AccessoryAttributeBuilder parentBuilder) {
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference, parentBuilder);
        if (this.modifiers().isEmpty()) {
            return builder;
        }
        class_1309 entity = slotReference.entity();
        Map slots = entity != null ? SlotTypeLoader.getSlotTypes(entity.method_37908()) : Map.of();
        for (Entry entry : this.modifiers()) {
            class_1322 attributeModifier = entry.modifier();
            String slotTarget = entry.slotName();
            if (!slots.containsKey(slotTarget) && !slotReference.slotName().equals(slotTarget) && !slotTarget.equals("any")) continue;
            if (entry.isStackable()) {
                builder.addStackable(entry.attribute(), attributeModifier);
                continue;
            }
            builder.addExclusive(entry.attribute(), attributeModifier);
        }
        return builder;
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();
        private boolean showInTooltip = true;

        private Builder() {
        }

        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public Builder add(class_6880<class_1320> holder, class_1322 attributeModifier, String slotName, boolean isStackable) {
            return this.addForSlot(holder, attributeModifier, slotName, isStackable);
        }

        public Builder addForSlot(class_6880<class_1320> holder, class_1322 attributeModifier, String slotName, boolean isStackable) {
            this.entries.add(new Entry(holder, attributeModifier, slotName, isStackable));
            return this;
        }

        public Builder addForAny(class_6880<class_1320> holder, class_1322 attributeModifier, boolean isStackable) {
            this.entries.add(new Entry(holder, attributeModifier, "any", isStackable));
            return this;
        }

        public Builder showInTooltip(boolean value) {
            this.showInTooltip = value;
            return this;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public AccessoryItemAttributeModifiers build() {
            return new AccessoryItemAttributeModifiers(Collections.unmodifiableList(this.entries), this.showInTooltip);
        }
    }

    public record Entry(class_6880<class_1320> attribute, class_1322 modifier, String slotName, boolean isStackable) {
        private static final Endec<class_6880<class_1320>> ATTRIBUTE_ENDEC = MinecraftEndecs.IDENTIFIER.xmapWithContext((context, attributeType) -> {
            if (attributeType.method_12836().equals("accessories")) {
                String path = attributeType.method_12832();
                if (path.contains("/")) {
                    path = path.replace("/", ":");
                }
                return SlotAttribute.getAttributeHolder(path);
            }
            return (class_6880)((class_6903.class_7862)((RegistriesAttribute)context.requireAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter().method_46623(class_7924.field_41251).orElseThrow(IllegalStateException::new)).comp_1131().method_46746(class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)attributeType)).orElseThrow(IllegalStateException::new);
        }, (context, attributeHolder) -> {
            class_1320 attribute = (class_1320)attributeHolder.comp_349();
            if (attribute instanceof SlotAttribute) {
                SlotAttribute slotAttribute = (SlotAttribute)attribute;
                String path = slotAttribute.slotName();
                if (UniqueSlotHandling.isUniqueSlot(path)) {
                    path = path.replace(":", "/");
                }
                return Accessories.of(path);
            }
            return ((RegistriesAttribute)context.requireAttributeValue(RegistriesAttribute.REGISTRIES)).registryManager().method_30530(class_7924.field_41251).method_10221((Object)attribute);
        });
        public static final Endec<Entry> ENDEC = StructEndecBuilder.of((StructField)ATTRIBUTE_ENDEC.fieldOf("type", Entry::attribute), (StructField)AttributeUtils.ATTRIBUTE_MODIFIER_ENDEC.flatFieldOf(Entry::modifier), (StructField)Endec.STRING.fieldOf("slot_name", Entry::slotName), (StructField)Endec.BOOLEAN.optionalFieldOf("is_stackable", Entry::isStackable, (Object)false), Entry::new);
    }
}

