/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.api.client.rendering.ClientTransformationUtils;
import io.wispforest.accessories.api.client.rendering.ModelTransformUtils;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryRenderTransformations;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.compat.config.RenderSlotTarget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.slf4j.Logger;

public class DefaultAccessoryRenderer
implements AccessoryRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DefaultAccessoryRenderer INSTANCE;
    private final Map<String, RenderHelper> slotToHelpers = new HashMap<String, RenderHelper>();
    private static final Map<String, RenderHelper> DEFAULT_HELPERS;

    public DefaultAccessoryRenderer() {
        this.slotToHelpers.putAll(DEFAULT_HELPERS);
    }

    public static void registerHelper(String slotType, RenderHelper helper) {
        Map<String, RenderHelper> helpers = DefaultAccessoryRenderer.INSTANCE.slotToHelpers;
        if (!helpers.containsKey(slotType)) {
            helpers.put(slotType, helper);
        } else {
            LOGGER.warn("[DefaultAccessoryRenderer] Unable to add to the main renderer instance due to a duplicate helper already exists!");
        }
    }

    @Override
    public <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(model instanceof class_572)) {
            return;
        }
        class_572 humanoidModel = (class_572)model;
        List<RenderSlotTarget> disabledTargetType = Accessories.config().clientOptions.disabledDefaultRenders();
        for (RenderSlotTarget target : disabledTargetType) {
            if (!reference.slotName().equals(target.slotType) || !target.targetType.isValid(stack.method_7909())) continue;
            return;
        }
        Consumer<class_4587> render = poseStack -> class_310.method_1551().method_1480().method_23178(stack, class_811.field_4319, light, class_4608.field_21444, poseStack, multiBufferSource, reference.entity().method_37908(), 0);
        AccessoryRenderTransformations translationData = (AccessoryRenderTransformations)stack.method_57825(AccessoriesDataComponents.RENDER_TRANSFORMATIONS, (Object)AccessoryRenderTransformations.EMPTY);
        Consumer<class_4587> translationAndRender = poseStack -> ClientTransformationUtils.transformStack(translationData.transformations(), poseStack, reference.entity(), (class_583<? extends class_1309>)humanoidModel, () -> render.accept((class_4587)poseStack));
        if (!translationData.disableDefaultTranslations()) {
            RenderHelper helper = this.slotToHelpers.get(reference.slotName());
            if (helper != null) {
                helper.render(translationAndRender, matrices, humanoidModel, reference);
            }
        } else {
            translationAndRender.accept(matrices);
        }
    }

    @Override
    public boolean shouldRenderInFirstPerson(class_1306 arm, class_1799 stack, SlotReference reference) {
        String slotName = reference.slotName();
        return (slotName.equals("hand") || slotName.equals("wrist") || slotName.equals("ring")) && (reference.slot() % 2 == 0 ? arm == class_1306.field_6183 : arm == class_1306.field_6182);
    }

    static {
        DEFAULT_HELPERS = Map.ofEntries(Map.entry("face", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "head", Side.FRONT);
                renderCall.accept(matrices);
            }
        }), Map.entry("hat", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "head", Side.TOP);
                matrices.method_22904(0.0, 0.25, 0.0);
                for (int i = 0; i < reference.getStack().method_7947(); ++i) {
                    renderCall.accept(matrices);
                    matrices.method_22904(0.0, 0.5, 0.0);
                }
            }
        }), Map.entry("back", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "body", Side.BACK);
                matrices.method_22905(1.5f, 1.5f, 1.5f);
                renderCall.accept(matrices);
            }
        }), Map.entry("necklace", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, "body", 0, 1, 1);
                matrices.method_22904(0.0, -0.25, 0.0);
                renderCall.accept(matrices);
            }
        }), Map.entry("cape", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, "body", 0, 1, -1);
                matrices.method_22904(0.0, -0.25, 0.0);
                renderCall.accept(matrices);
            }
        }), Map.entry("ring", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_arm" : "left_arm";
                int xPercent = reference.slot() % 2 == 0 ? 1 : -1;
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, modelTarget, xPercent, -1, 0);
                int offset = reference.slot() / 2;
                matrices.method_22904((double)((reference.slot() % 2 == 0 ? -1 : 1) * offset) * -1.0E-4, 0.25 * (double)(offset + 1), 0.0);
                matrices.method_22905(0.5f, 0.5f, 0.5f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                for (int i = 0; i < reference.getStack().method_7947(); ++i) {
                    renderCall.accept(matrices);
                    matrices.method_22904(0.0, 0.0, reference.slot() % 2 == 0 ? -0.5 : 0.5);
                }
            }
        }), Map.entry("wrist", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_arm" : "left_arm";
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, modelTarget, 0, -0.5, 0);
                matrices.method_22905(1.01f, 1.01f, 1.01f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                renderCall.accept(matrices);
            }
        }), Map.entry("hand", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_arm" : "left_arm";
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, modelTarget, Side.BOTTOM);
                matrices.method_22904(0.0, 0.25, 0.0);
                matrices.method_22905(1.02f, 1.02f, 1.02f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                renderCall.accept(matrices);
            }
        }), Map.entry("belt", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "body", Side.BOTTOM);
                matrices.method_22905(1.01f, 1.01f, 1.01f);
                renderCall.accept(matrices);
            }
        }), Map.entry("anklet", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                String modelTarget = reference.slot() % 2 == 0 ? "right_leg" : "left_leg";
                ModelTransformUtils.transformToModelPart(matrices, reference.entity(), humanoidModel, modelTarget, 0, -0.5, 0);
                matrices.method_22905(1.01f, 1.01f, 1.01f);
                renderCall.accept(matrices);
            }
        }), Map.entry("shoes", new RenderHelper(){

            @Override
            public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                matrices.method_22903();
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "right_leg", Side.BOTTOM);
                matrices.method_22904(0.0, 0.25, 0.0);
                matrices.method_22905(1.02f, 1.02f, 1.02f);
                renderCall.accept(matrices);
                matrices.method_22909();
                matrices.method_22903();
                ModelTransformUtils.transformToFace(matrices, reference.entity(), humanoidModel, "left_leg", Side.BOTTOM);
                matrices.method_22904(0.0, 0.25, 0.0);
                matrices.method_22905(1.02f, 1.02f, 1.02f);
                renderCall.accept(matrices);
                matrices.method_22909();
            }
        }));
        INSTANCE = new DefaultAccessoryRenderer();
    }

    public static interface RenderHelper {
        public <M extends class_1309> void render(Consumer<class_4587> var1, class_4587 var2, class_572<M> var3, SlotReference var4);
    }
}

