/*
 * Decompiled with CFR 0.152.
 */
package org.bson.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.Parameterizable;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.internal.ChildCodecRegistry;
import org.bson.internal.CodecCache;
import org.bson.internal.CycleDetectingCodecRegistry;

public final class ProvidersCodecRegistry
implements CycleDetectingCodecRegistry {
    private final List<CodecProvider> codecProviders;
    private final CodecCache codecCache = new CodecCache();

    public ProvidersCodecRegistry(List<? extends CodecProvider> codecProviders) {
        Assertions.isTrueArgument("codecProviders must not be null or empty", codecProviders != null && codecProviders.size() > 0);
        this.codecProviders = new ArrayList<CodecProvider>(codecProviders);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz) {
        return this.get(new ChildCodecRegistry<T>(this, clazz, null));
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments) {
        Assertions.notNull("typeArguments", typeArguments);
        Assertions.isTrueArgument(String.format("typeArguments size should equal the number of type parameters in class %s, but is %d", clazz, typeArguments.size()), clazz.getTypeParameters().length == typeArguments.size());
        return this.get(new ChildCodecRegistry<T>(this, clazz, typeArguments));
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.get(clazz, Collections.emptyList(), registry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        for (CodecProvider provider : this.codecProviders) {
            Codec<T> codec = ProvidersCodecRegistry.getFromCodecProvider(provider, clazz, typeArguments, registry);
            if (codec == null) continue;
            return codec;
        }
        return null;
    }

    @Override
    public <T> Codec<T> get(ChildCodecRegistry<T> context) {
        CodecCache.CodecCacheKey codecCacheKey = new CodecCache.CodecCacheKey(context.getCodecClass(), context.getTypes().orElse(null));
        return this.codecCache.get(codecCacheKey).orElseGet(() -> {
            for (CodecProvider provider : this.codecProviders) {
                Codec codec = ProvidersCodecRegistry.getFromCodecProvider(provider, context.getCodecClass(), context.getTypes().orElse(Collections.emptyList()), context);
                if (codec == null) continue;
                return this.codecCache.putIfAbsent(codecCacheKey, codec);
            }
            throw new CodecConfigurationException(String.format("Can't find a codec for %s.", codecCacheKey));
        });
    }

    @Nullable
    public static <T> Codec<T> getFromCodecProvider(CodecProvider provider, Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        Codec<Object> codec = provider.get(clazz, typeArguments, registry);
        if (codec instanceof Parameterizable && !typeArguments.isEmpty()) {
            Codec<?> parameterizedCodec = ((Parameterizable)((Object)codec)).parameterize(registry, typeArguments);
            codec = parameterizedCodec;
        }
        return codec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProvidersCodecRegistry that = (ProvidersCodecRegistry)o;
        if (this.codecProviders.size() != that.codecProviders.size()) {
            return false;
        }
        for (int i = 0; i < this.codecProviders.size(); ++i) {
            if (this.codecProviders.get(i).getClass() == that.codecProviders.get(i).getClass()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.codecProviders.hashCode();
    }

    public String toString() {
        return "ProvidersCodecRegistry{codecProviders=" + this.codecProviders + '}';
    }
}

