/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ConditionProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRuntime;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Symbol;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSFunction;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.PropertyDescriptor;

public class SetFunctionNameNode
extends JavaScriptBaseNode {
    private final ConditionProfile isSymbolProfile = ConditionProfile.createBinaryProfile();

    protected SetFunctionNameNode() {
    }

    public static SetFunctionNameNode create() {
        return new SetFunctionNameNode();
    }

    public Object execute(Object functionValue, Object propertyKey) {
        return this.execute(functionValue, propertyKey, null);
    }

    public Object execute(Object functionValue, Object propertyKey, TruffleString prefix) {
        TruffleString name;
        assert (JSFunction.isJSFunction(functionValue));
        assert (JSRuntime.isPropertyKey(propertyKey));
        TruffleString truffleString = name = this.isSymbolProfile.profile(propertyKey instanceof Symbol) ? ((Symbol)propertyKey).toFunctionNameString() : (TruffleString)propertyKey;
        if (prefix != null && !Strings.isEmpty(prefix)) {
            name = SetFunctionNameNode.concatenate(prefix, name);
        }
        return SetFunctionNameNode.setFunctionName((JSFunctionObject)functionValue, name);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString concatenate(TruffleString prefix, TruffleString name) {
        return Strings.concatAll(prefix, Strings.SPACE, name);
    }

    private static Object setFunctionName(JSFunctionObject functionValue, TruffleString name) {
        PropertyDescriptor propDesc = PropertyDescriptor.createData(name, false, false, true);
        JSRuntime.definePropertyOrThrow(functionValue, JSFunction.NAME, propDesc);
        return functionValue;
    }
}

