/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.instrumentation.Tag;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.js.builtins.OperatorsBuiltins;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSConstantNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToNumericNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.BigInt;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRuntime;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Symbol;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.util.Set;

public abstract class JSToNumericNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSToNumberNode toNumberNode;
    @Node.Child
    private JSToPrimitiveNode toPrimitiveNode;
    private final boolean toNumericOperand;

    public abstract Object execute(Object var1);

    protected JSToNumericNode(boolean toNumericOperand) {
        this.toNumericOperand = toNumericOperand;
    }

    public static JSToNumericNode create(boolean toNumericOperand) {
        return JSToNumericNodeGen.create(toNumericOperand);
    }

    public static JSToNumericNode create() {
        return JSToNumericNode.create(false);
    }

    public static JSToNumericNode createToNumericOperand() {
        return JSToNumericNode.create(true);
    }

    public static JavaScriptNode create(JavaScriptNode child, boolean toNumericOperand) {
        Object constantOperand;
        if (child.isResultAlwaysOfType(Number.class) || child.isResultAlwaysOfType(Integer.TYPE) || child.isResultAlwaysOfType(Double.TYPE)) {
            return child;
        }
        if (child instanceof JSConstantNode && (constantOperand = ((JSConstantNode)child).getValue()) != null && !(constantOperand instanceof Symbol) && JSRuntime.isJSPrimitive(constantOperand)) {
            return JSConstantNode.create(JSRuntime.toNumeric(constantOperand));
        }
        return JSToNumericNodeGen.JSToNumericWrapperNodeGen.create(child, toNumericOperand);
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        return JSToNumericNode.create(child, false);
    }

    public static JavaScriptNode createToNumericOperand(JavaScriptNode child) {
        return JSToNumericNode.create(child, true);
    }

    @Specialization
    protected static int doInt(int value) {
        return value;
    }

    @Specialization
    protected static double doDouble(double value) {
        return value;
    }

    @Specialization
    protected Object doBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"isJSBigInt(value)"})
    protected Object doJSBigInt(Object value) {
        return this.toPrimitive(value);
    }

    @Specialization(guards={"isToNumericOperand()"})
    protected Object doOverloaded(JSOverloadedOperatorsObject arg) {
        OperatorsBuiltins.checkOverloadedOperatorsAllowed(arg, this);
        return arg;
    }

    @Specialization(guards={"isToNumericOperand()", "!isJSBigInt(value)", "!hasOverloadedOperators(value)"})
    protected Object doToNumericOperandOther(Object value) {
        Object primValue = this.toPrimitive(value);
        if (JSRuntime.isBigInt(primValue)) {
            return primValue;
        }
        return this.toNumber(primValue);
    }

    @Specialization(guards={"!isToNumericOperand()", "!isJSBigInt(value)"})
    protected Object doToNumericOther(Object value) {
        Object primValue = this.toPrimitive(value);
        if (JSRuntime.isBigInt(primValue)) {
            return primValue;
        }
        return this.toNumber(primValue);
    }

    private Number toNumber(Object value) {
        if (this.toNumberNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toNumberNode = this.insert(JSToNumberNode.create());
        }
        return this.toNumberNode.executeNumber(value);
    }

    private Object toPrimitive(Object value) {
        if (this.toPrimitiveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toPrimitiveNode = this.insert(JSToPrimitiveNode.createHintNumber());
        }
        return this.toPrimitiveNode.execute(value);
    }

    protected boolean isToNumericOperand() {
        return this.toNumericOperand;
    }

    public static abstract class JSToNumericWrapperNode
    extends JSUnaryNode {
        @Node.Child
        private JSToNumericNode toNumericNode;
        private final boolean toNumericOperand;

        protected JSToNumericWrapperNode(JavaScriptNode operand, boolean toNumericOperand) {
            super(operand);
            this.toNumericOperand = toNumericOperand;
        }

        @Specialization
        protected Object doDefault(Object value) {
            if (this.toNumericNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumericNode = this.insert(JSToNumericNode.create(this.toNumericOperand));
            }
            return this.toNumericNode.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToNumericNode.create(JSToNumericWrapperNode.cloneUninitialized(this.getOperand(), materializedTags), this.toNumericOperand);
        }

        @Override
        public String expressionToString() {
            return this.getOperand().expressionToString();
        }
    }
}

