/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.validator;

import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.internal.validator.NoOpFieldNameValidator;
import org.bson.FieldNameValidator;

public class UpdateFieldNameValidator
implements FieldNameValidator {
    private int numFields = 0;

    @Override
    public boolean validate(String fieldName) {
        ++this.numFields;
        return fieldName.startsWith("$");
    }

    @Override
    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(fieldName.startsWith("$"));
        return String.format("All update operators must start with '$', but '%s' does not", fieldName);
    }

    @Override
    public FieldNameValidator getValidatorForField(String fieldName) {
        return new NoOpFieldNameValidator();
    }

    @Override
    public void start() {
        this.numFields = 0;
    }

    @Override
    public void end() {
        if (this.numFields == 0) {
            throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
        }
    }
}

