/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.operation;

import com.cobblemon.mod.relocations.mongodb.MongoCommandException;
import com.cobblemon.mod.relocations.mongodb.MongoNamespace;
import com.cobblemon.mod.relocations.mongodb.WriteConcern;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.internal.async.ErrorHandlingResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.async.SingleResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.binding.AsyncWriteBinding;
import com.cobblemon.mod.relocations.mongodb.internal.binding.WriteBinding;
import com.cobblemon.mod.relocations.mongodb.internal.operation.AsyncWriteOperation;
import com.cobblemon.mod.relocations.mongodb.internal.operation.CommandOperationHelper;
import com.cobblemon.mod.relocations.mongodb.internal.operation.DocumentHelper;
import com.cobblemon.mod.relocations.mongodb.internal.operation.OperationHelper;
import com.cobblemon.mod.relocations.mongodb.internal.operation.WriteConcernHelper;
import com.cobblemon.mod.relocations.mongodb.internal.operation.WriteOperation;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;

public class DropIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final String indexName;
    private final BsonDocument indexKeys;
    private final WriteConcern writeConcern;
    private long maxTimeMS;

    public DropIndexOperation(MongoNamespace namespace, String indexName) {
        this(namespace, indexName, null);
    }

    public DropIndexOperation(MongoNamespace namespace, BsonDocument keys) {
        this(namespace, keys, null);
    }

    public DropIndexOperation(MongoNamespace namespace, String indexName, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexName = Assertions.notNull("indexName", indexName);
        this.indexKeys = null;
        this.writeConcern = writeConcern;
    }

    public DropIndexOperation(MongoNamespace namespace, BsonDocument indexKeys, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexKeys = Assertions.notNull("indexKeys", indexKeys);
        this.indexName = null;
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DropIndexOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> {
            try {
                CommandOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommand(), connection, CommandOperationHelper.writeConcernErrorTransformer());
            }
            catch (MongoCommandException e) {
                CommandOperationHelper.rethrowIfNotNamespaceError(e);
            }
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                SingleResultCallback releasingCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                CommandOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommand(), connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), (result, t1) -> {
                    if (t1 != null && !CommandOperationHelper.isNamespaceError(t1)) {
                        releasingCallback.onResult(null, t1);
                    } else {
                        releasingCallback.onResult(result, null);
                    }
                });
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("dropIndexes", new BsonString(this.namespace.getCollectionName()));
        if (this.indexName != null) {
            command.put("index", new BsonString(this.indexName));
        } else {
            command.put("index", this.indexKeys);
        }
        DocumentHelper.putIfNotZero(command, "maxTimeMS", this.maxTimeMS);
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, command);
        return command;
    }
}

