/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.connection;

import com.cobblemon.mod.relocations.mongodb.MongoCommandException;
import com.cobblemon.mod.relocations.mongodb.MongoSecurityException;
import com.cobblemon.mod.relocations.mongodb.ServerApi;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterConnectionMode;
import com.cobblemon.mod.relocations.mongodb.connection.ConnectionDescription;
import com.cobblemon.mod.relocations.mongodb.internal.async.ErrorHandlingResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.async.SingleResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.authentication.NativeAuthenticationHelper;
import com.cobblemon.mod.relocations.mongodb.internal.connection.Authenticator;
import com.cobblemon.mod.relocations.mongodb.internal.connection.CommandHelper;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalConnection;
import com.cobblemon.mod.relocations.mongodb.internal.connection.MongoCredentialWithCache;
import com.cobblemon.mod.relocations.mongodb.internal.diagnostics.logging.Logger;
import com.cobblemon.mod.relocations.mongodb.internal.diagnostics.logging.Loggers;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;

class NativeAuthenticator
extends Authenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");

    NativeAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
    }

    @Override
    public void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        try {
            BsonDocument nonceResponse = CommandHelper.executeCommand(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), this.getClusterConnectionMode(), this.getServerApi(), connection);
            BsonDocument authCommand = NativeAuthenticationHelper.getAuthCommand(this.getUserNameNonNull(), this.getPasswordNonNull(), ((BsonString)nonceResponse.get("nonce")).getValue());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), authCommand, this.getClusterConnectionMode(), this.getServerApi(), connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), this.getClusterConnectionMode(), this.getServerApi(), connection, (nonceResult, t) -> {
            if (t != null) {
                errHandlingCallback.onResult(null, this.translateThrowable(t));
            } else {
                CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getAuthCommand(this.getUserNameNonNull(), this.getPasswordNonNull(), ((BsonString)nonceResult.get("nonce")).getValue()), this.getClusterConnectionMode(), this.getServerApi(), connection, (result, t1) -> {
                    if (t1 != null) {
                        errHandlingCallback.onResult(null, this.translateThrowable(t1));
                    } else {
                        errHandlingCallback.onResult(null, null);
                    }
                });
            }
        });
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

