/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.connection;

import com.cobblemon.mod.relocations.mongodb.internal.connection.BsonWriterHelper;
import com.cobblemon.mod.relocations.mongodb.internal.connection.LevelCountingBsonWriter;
import java.util.List;
import org.bson.BsonBinaryWriter;
import org.bson.BsonElement;
import org.bson.BsonReader;

public class ElementExtendingBsonWriter
extends LevelCountingBsonWriter {
    private final BsonBinaryWriter writer;
    private final List<BsonElement> extraElements;

    public ElementExtendingBsonWriter(BsonBinaryWriter writer, List<BsonElement> extraElements) {
        super(writer);
        this.writer = writer;
        this.extraElements = extraElements;
    }

    @Override
    public void writeEndDocument() {
        if (this.getCurrentLevel() == 0) {
            BsonWriterHelper.writeElements(this.writer, this.extraElements);
        }
        super.writeEndDocument();
    }

    @Override
    public void pipe(BsonReader reader) {
        if (this.getCurrentLevel() == -1) {
            this.writer.pipe(reader, this.extraElements);
        } else {
            this.writer.pipe(reader);
        }
    }
}

