/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.connection;

import com.cobblemon.mod.relocations.mongodb.MongoNamespace;
import com.cobblemon.mod.relocations.mongodb.ReadPreference;
import com.cobblemon.mod.relocations.mongodb.RequestContext;
import com.cobblemon.mod.relocations.mongodb.ServerApi;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterConnectionMode;
import com.cobblemon.mod.relocations.mongodb.internal.async.SingleResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.connection.CommandMessage;
import com.cobblemon.mod.relocations.mongodb.internal.connection.CommandProtocol;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalConnection;
import com.cobblemon.mod.relocations.mongodb.internal.connection.OperationContext;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ProtocolHelper;
import com.cobblemon.mod.relocations.mongodb.internal.connection.SplittablePayload;
import com.cobblemon.mod.relocations.mongodb.internal.session.SessionContext;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

class CommandProtocolImpl<T>
implements CommandProtocol<T> {
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final SplittablePayload payload;
    private final ReadPreference readPreference;
    private final FieldNameValidator commandFieldNameValidator;
    private final FieldNameValidator payloadFieldNameValidator;
    private final Decoder<T> commandResultDecoder;
    private final boolean responseExpected;
    private final ClusterConnectionMode clusterConnectionMode;
    private final RequestContext requestContext;
    private SessionContext sessionContext;
    private final ServerApi serverApi;
    private final OperationContext operationContext;

    CommandProtocolImpl(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, RequestContext requestContext, OperationContext operationContext) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(Assertions.notNull("database", database), "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandFieldNameValidator = Assertions.notNull("commandFieldNameValidator", commandFieldNameValidator);
        this.readPreference = readPreference;
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.responseExpected = responseExpected;
        this.payload = payload;
        this.payloadFieldNameValidator = payloadFieldNameValidator;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
        this.operationContext = operationContext;
        Assertions.isTrueArgument("payloadFieldNameValidator cannot be null if there is a payload.", payload == null || payloadFieldNameValidator != null);
    }

    @Override
    @Nullable
    public T execute(InternalConnection connection) {
        return connection.sendAndReceive(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, this.requestContext, this.operationContext);
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<T> callback) {
        try {
            connection.sendAndReceiveAsync(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, this.requestContext, this.operationContext, (result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            });
        }
        catch (Throwable t2) {
            callback.onResult(null, t2);
        }
    }

    @Override
    public CommandProtocolImpl<T> sessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    private CommandMessage getCommandMessage(InternalConnection connection) {
        return new CommandMessage(this.namespace, this.command, this.commandFieldNameValidator, this.readPreference, ProtocolHelper.getMessageSettings(connection.getDescription()), this.responseExpected, this.payload, this.payloadFieldNameValidator, this.clusterConnectionMode, this.serverApi);
    }
}

