/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.async.function;

import com.cobblemon.mod.relocations.mongodb.annotations.NotThreadSafe;
import com.cobblemon.mod.relocations.mongodb.internal.async.function.RetryState;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

@NotThreadSafe
public final class RetryingSyncSupplier<R>
implements Supplier<R> {
    private final RetryState state;
    private final BiPredicate<RetryState, Throwable> retryPredicate;
    private final BiFunction<Throwable, Throwable, Throwable> failedResultTransformer;
    private final Supplier<R> syncFunction;

    public RetryingSyncSupplier(RetryState state, BiFunction<Throwable, Throwable, Throwable> failedResultTransformer, BiPredicate<RetryState, Throwable> retryPredicate, Supplier<R> syncFunction) {
        this.state = state;
        this.retryPredicate = retryPredicate;
        this.failedResultTransformer = failedResultTransformer;
        this.syncFunction = syncFunction;
    }

    @Override
    public R get() {
        while (true) {
            try {
                return this.syncFunction.get();
            }
            catch (RuntimeException attemptException) {
                this.state.advanceOrThrow(attemptException, this.failedResultTransformer, this.retryPredicate);
                continue;
            }
            catch (Exception attemptException) {
                this.state.advanceOrThrow(new RuntimeException(attemptException), this.failedResultTransformer, this.retryPredicate);
                continue;
            }
            break;
        }
    }
}

