/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.connection;

import com.cobblemon.mod.relocations.mongodb.ServerAddress;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.connection.SocketSettings;
import com.cobblemon.mod.relocations.mongodb.connection.SslSettings;
import com.cobblemon.mod.relocations.mongodb.connection.Stream;
import com.cobblemon.mod.relocations.mongodb.connection.StreamFactory;
import com.cobblemon.mod.relocations.mongodb.internal.connection.AsynchronousSocketChannelStream;
import com.cobblemon.mod.relocations.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.nio.channels.AsynchronousChannelGroup;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final PowerOfTwoBufferPool bufferProvider = PowerOfTwoBufferPool.DEFAULT;
    private final SocketSettings settings;
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings, @Nullable AsynchronousChannelGroup group) {
        if (sslSettings.isEnabled()) {
            throw new UnsupportedOperationException("No SSL support in java.nio.channels.AsynchronousSocketChannel. For SSL support use com.mongodb.connection.TlsChannelStreamFactoryFactory");
        }
        this.settings = Assertions.notNull("settings", settings);
        this.group = group;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.settings, this.bufferProvider, this.group);
    }
}

