/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.client.model.search;

import com.cobblemon.mod.relocations.mongodb.annotations.Beta;
import com.cobblemon.mod.relocations.mongodb.annotations.Sealed;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchConstructibleBson;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchPath;
import com.cobblemon.mod.relocations.mongodb.internal.Iterables;
import com.cobblemon.mod.relocations.mongodb.internal.client.model.Util;
import java.util.Iterator;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchHighlight
extends Bson {
    public SearchHighlight maxCharsToExamine(int var1);

    public SearchHighlight maxNumPassages(int var1);

    public static SearchHighlight paths(SearchPath path, SearchPath ... paths) {
        return SearchHighlight.paths(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static SearchHighlight paths(Iterable<? extends SearchPath> paths) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBson(new BsonDocument("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static SearchHighlight of(Bson highlight) {
        return new SearchConstructibleBson(Assertions.notNull("highlight", highlight));
    }
}

