/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util.math;

import com.cobblemon.mod.common.util.math.CatmullRomCurveKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/util/math/CatmullRomCurve;", "", "", "", "nodes", "<init>", "(Ljava/util/List;)V", "t", "getY", "(D)D", "Ljava/util/List;", "getNodes", "()Ljava/util/List;", "common"})
public final class CatmullRomCurve {
    @NotNull
    private final List<Double> nodes;

    public CatmullRomCurve(@NotNull List<Double> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.nodes = nodes;
    }

    @NotNull
    public final List<Double> getNodes() {
        return this.nodes;
    }

    public final double getY(double t) {
        List<Double> points = this.nodes;
        double p = (double)(points.size() - 1) * t;
        int intPoint = (int)Math.floor(p);
        double weight = p - (double)intPoint;
        double p0 = ((Number)points.get(intPoint <= 0 ? 0 : intPoint - 1)).doubleValue();
        double p1 = ((Number)points.get(intPoint < 0 ? 0 : intPoint)).doubleValue();
        double p2 = ((Number)points.get(intPoint > points.size() - 2 ? points.size() - 1 : intPoint + 1)).doubleValue();
        double p3 = ((Number)points.get(intPoint > points.size() - 3 ? points.size() - 1 : intPoint + 2)).doubleValue();
        return CatmullRomCurveKt.catmullRom(weight, p0, p1, p2, p3);
    }
}

