/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.serverhandling.battle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.net.messages.client.battle.BattleInitializePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMessagePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMusicPacket;
import com.cobblemon.mod.common.net.messages.server.battle.SpectateBattlePacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/cobblemon/mod/common/net/serverhandling/battle/SpectateBattleHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/cobblemon/mod/common/net/messages/server/battle/SpectateBattlePacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "player", "", "handle", "(Lcom/cobblemon/mod/common/net/messages/server/battle/SpectateBattlePacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_3222;)V", "target", "spectateBattle", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)V", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "common"})
@SourceDebugExtension(value={"SMAP\nSpectateBattleHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpectateBattleHandler.kt\ncom/cobblemon/mod/common/net/serverhandling/battle/SpectateBattleHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n808#2,11:85\n295#2,2:96\n1#3:98\n*S KotlinDebug\n*F\n+ 1 SpectateBattleHandler.kt\ncom/cobblemon/mod/common/net/serverhandling/battle/SpectateBattleHandler\n*L\n38#1:85,11\n38#1:96,2\n*E\n"})
public final class SpectateBattleHandler
implements ServerNetworkPacketHandler<SpectateBattlePacket> {
    @NotNull
    public static final SpectateBattleHandler INSTANCE = new SpectateBattleHandler();
    private static final Logger LOGGER = LogManager.getLogger();

    private SpectateBattleHandler() {
    }

    public final Logger getLOGGER() {
        return LOGGER;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(@NotNull SpectateBattlePacket packet, @NotNull MinecraftServer server, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayerId(packet.getTargetedEntityId());
        if (battle != null && Cobblemon.INSTANCE.getConfig().getAllowSpectating()) {
            Object v0;
            Object element$iv2;
            block7: {
                void $this$firstOrNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = battle.getActors();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PlayerBattleActor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    PlayerBattleActor it = (PlayerBattleActor)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)packet.getTargetedEntityId())) continue;
                    v0 = element$iv2;
                    break block7;
                }
                v0 = null;
            }
            PlayerBattleActor target = v0;
            class_3222 class_32222 = PlayerExtensionsKt.getPlayer(packet.getTargetedEntityId());
            if (class_32222 == null) {
                return;
            }
            class_3222 targetedPlayerEntity = class_32222;
            Class<class_1309> clazz = class_1309.class;
            float f = Cobblemon.INSTANCE.getConfig().getBattleSpectateMaxDistance();
            if (!Intrinsics.areEqual((Object)PlayerExtensionsKt.traceFirstEntityCollision$default((class_1309)player, f, 0.0f, clazz, (class_1297)player, element$iv2 = class_3959.class_242.field_1348, 2, null), (Object)targetedPlayerEntity)) {
                class_5250 class_52502 = LocalizationUtilsKt.lang("ui.interact.failed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
                player.method_43496((class_2561)TextKt.yellow(class_52502));
                return;
            }
            this.spectateBattle(targetedPlayerEntity, player);
            PlayerBattleActor playerBattleActor = target;
            if (playerBattleActor != null && (playerBattleActor = playerBattleActor.getBattleTheme()) != null) {
                PlayerBattleActor it = playerBattleActor;
                boolean bl = false;
                CobblemonNetwork.INSTANCE.sendPacket(player, new BattleMusicPacket((class_2960)it, 0.0f, 0.0f, false, 14, null));
            }
        } else {
            LOGGER.error("Battle of player id " + packet.getTargetedEntityId() + " not found (" + player.method_5667() + " tried spectating)");
        }
    }

    public final void spectateBattle(@NotNull class_3222 target, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Intrinsics.areEqual((Object)player, (Object)target)) {
            class_5250 class_52502 = LocalizationUtilsKt.lang("command.spectatebattle.self_spectate_disallowed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
            player.method_43496((class_2561)TextKt.red(class_52502));
            return;
        }
        if (!PlayerExtensionsKt.isInBattle(target)) {
            class_5250 class_52503 = LocalizationUtilsKt.lang("command.spectatebattle.player_not_in_battle", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"lang(...)");
            player.method_43496((class_2561)TextKt.red(class_52503));
            return;
        }
        if (PlayerExtensionsKt.isInBattle(player)) {
            class_5250 class_52504 = LocalizationUtilsKt.lang("command.spectatebattle.while_battling_disallowed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"lang(...)");
            player.method_43496((class_2561)TextKt.red(class_52504));
            return;
        }
        PokemonBattle pokemonBattle = BattleRegistry.getBattleByParticipatingPlayer(target);
        if (pokemonBattle == null) {
            return;
        }
        PokemonBattle battle = pokemonBattle;
        Set<UUID> set = battle.getSpectators();
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        set.add(uUID);
        CobblemonNetwork.INSTANCE.sendPacket(player, new BattleInitializePacket(battle, null));
        CobblemonNetwork.INSTANCE.sendPacket(player, new BattleMessagePacket(battle.getChatLog()));
    }
}

