/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.battle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonPropertyExtractor;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.IntSize;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0004,-./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0002\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rR\u001a\u0010\u0010\u001a\u00020\u000f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010#\u001a\u00020\"8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\"\u0010)\u001a\u00020\"8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b)\u0010$\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(\u00a8\u00060"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/battles/BattleSide;", "allySide", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/battles/BattleSide;)V", "Lnet/minecraft/class_9129;", "buffer", "", "encode", "(Lnet/minecraft/class_9129;)V", "decode", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_2960;", "getId", "()Lnet/minecraft/class_2960;", "Ljava/util/UUID;", "battleId", "Ljava/util/UUID;", "getBattleId", "()Ljava/util/UUID;", "setBattleId", "(Ljava/util/UUID;)V", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "battleFormat", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "getBattleFormat", "()Lcom/cobblemon/mod/common/battles/BattleFormat;", "setBattleFormat", "(Lcom/cobblemon/mod/common/battles/BattleFormat;)V", "Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleSideDTO;", "side1", "Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleSideDTO;", "getSide1", "()Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleSideDTO;", "setSide1", "(Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleSideDTO;)V", "side2", "getSide2", "setSide2", "Companion", "BattleSideDTO", "BattleActorDTO", "ActiveBattlePokemonDTO", "common"})
@SourceDebugExtension(value={"SMAP\nBattleInitializePacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleInitializePacket.kt\ncom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n11561#2:251\n11896#2,2:252\n11561#2:254\n11896#2,2:255\n11898#2:261\n11898#2:262\n1563#3:257\n1634#3,3:258\n*S KotlinDebug\n*F\n+ 1 BattleInitializePacket.kt\ncom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket\n*L\n62#1:251\n62#1:252,2\n64#1:254\n64#1:255,2\n64#1:261\n62#1:262\n69#1:257\n69#1:258,3\n*E\n"})
public final class BattleInitializePacket
implements NetworkPacket<BattleInitializePacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_2960 id;
    public UUID battleId;
    public BattleFormat battleFormat;
    public BattleSideDTO side1;
    public BattleSideDTO side2;
    @NotNull
    private static final class_2960 ID = MiscUtilsKt.cobblemonResource("battle_initialize");

    public BattleInitializePacket() {
        this.id = ID;
    }

    @Override
    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    @NotNull
    public final UUID getBattleId() {
        UUID uUID = this.battleId;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"battleId");
        return null;
    }

    public final void setBattleId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.battleId = uUID;
    }

    @NotNull
    public final BattleFormat getBattleFormat() {
        BattleFormat battleFormat = this.battleFormat;
        if (battleFormat != null) {
            return battleFormat;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"battleFormat");
        return null;
    }

    public final void setBattleFormat(@NotNull BattleFormat battleFormat) {
        Intrinsics.checkNotNullParameter((Object)battleFormat, (String)"<set-?>");
        this.battleFormat = battleFormat;
    }

    @NotNull
    public final BattleSideDTO getSide1() {
        BattleSideDTO battleSideDTO = this.side1;
        if (battleSideDTO != null) {
            return battleSideDTO;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"side1");
        return null;
    }

    public final void setSide1(@NotNull BattleSideDTO battleSideDTO) {
        Intrinsics.checkNotNullParameter((Object)battleSideDTO, (String)"<set-?>");
        this.side1 = battleSideDTO;
    }

    @NotNull
    public final BattleSideDTO getSide2() {
        BattleSideDTO battleSideDTO = this.side2;
        if (battleSideDTO != null) {
            return battleSideDTO;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"side2");
        return null;
    }

    public final void setSide2(@NotNull BattleSideDTO battleSideDTO) {
        Intrinsics.checkNotNullParameter((Object)battleSideDTO, (String)"<set-?>");
        this.side2 = battleSideDTO;
    }

    /*
     * WARNING - void declaration
     */
    public BattleInitializePacket(@NotNull PokemonBattle battle, @Nullable BattleSide allySide) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        this();
        UUID uUID = battle.getBattleId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-battleId>(...)");
        this.setBattleId(uUID);
        this.setBattleFormat(battle.getFormat());
        BattleSide[] battleSideArray = new BattleSide[]{battle.getSide1(), battle.getSide2()};
        BattleSide[] $this$map$iv = battleSideArray;
        boolean $i$f$map = false;
        BattleSide[] battleSideArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv2;
            void side;
            void item$iv$iv;
            void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BattleActor[] $this$map$iv2 = side.getActors();
            boolean $i$f$map2 = false;
            BattleActor[] battleActorArray = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
            boolean $i$f$mapTo2 = false;
            int n2 = ((void)$this$mapTo$iv$iv2).length;
            for (int j = 0; j < n2; ++j) {
                void $this$mapTo$iv$iv3;
                void actor;
                void item$iv$iv2;
                void var22_21 = item$iv$iv2 = $this$mapTo$iv$iv2[j];
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                UUID uUID2 = actor.getUuid();
                String string = actor.getShowdownId();
                class_5250 class_52502 = actor.getName();
                Iterable $this$map$iv3 = actor.getActivePokemon();
                boolean $i$f$map3 = false;
                Iterable iterable = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                    ActiveBattlePokemonDTO activeBattlePokemonDTO;
                    void it;
                    ActiveBattlePokemon activeBattlePokemon = (ActiveBattlePokemon)item$iv$iv3;
                    Collection collection3 = destination$iv$iv3;
                    boolean bl3 = false;
                    if (it.getBattlePokemon() != null) {
                        BattlePokemon pkm;
                        boolean bl4 = false;
                        activeBattlePokemonDTO = ActiveBattlePokemonDTO.Companion.fromPokemon(pkm, Intrinsics.areEqual((Object)allySide, (Object)side), it.getIllusion());
                    } else {
                        activeBattlePokemonDTO = null;
                    }
                    collection3.add(activeBattlePokemonDTO);
                }
                List list = (List)destination$iv$iv3;
                ActorType actorType = actor.getType();
                collection2.add(new BattleActorDTO(uUID2, class_52502, string, list, actorType));
            }
            List list = (List)destination$iv$iv2;
            collection.add(new BattleSideDTO(list));
        }
        List sides = (List)destination$iv$iv;
        this.setSide1((BattleSideDTO)sides.get(0));
        this.setSide2((BattleSideDTO)sides.get(1));
    }

    @Override
    public void encode(@NotNull class_9129 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.method_10797(this.getBattleId());
        this.getBattleFormat().saveToBuffer(buffer);
        BattleSideDTO[] battleSideDTOArray = new BattleSideDTO[]{this.getSide1(), this.getSide2()};
        for (BattleSideDTO side : battleSideDTOArray) {
            NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, side.getActors().size());
            for (BattleActorDTO actor : side.getActors()) {
                buffer.method_10797(actor.getUuid());
                class_8824.field_49668.encode((Object)buffer, (Object)actor.getDisplayName());
                BufferUtilsKt.writeString((ByteBuf)buffer, actor.getShowdownId());
                NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, actor.getActivePokemon().size());
                for (ActiveBattlePokemonDTO activePokemon : actor.getActivePokemon()) {
                    buffer.method_52964(activePokemon != null);
                    ActiveBattlePokemonDTO activeBattlePokemonDTO = activePokemon;
                    if (activeBattlePokemonDTO == null) continue;
                    activeBattlePokemonDTO.saveToBuffer(buffer);
                }
                NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, actor.getType().ordinal());
            }
        }
    }

    private final void decode(class_9129 buffer) {
        UUID uUID = buffer.method_10790();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
        this.setBattleId(uUID);
        this.setBattleFormat(BattleFormat.Companion.loadFromBuffer(buffer));
        List sides = new ArrayList();
        int n = 2;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            List actors = new ArrayList();
            int n2 = NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_BYTE);
            for (int j = 0; j < n2; ++j) {
                int it2 = j;
                boolean bl2 = false;
                UUID uuid = buffer.method_10790();
                Object object = class_8824.field_49668.decode((Object)buffer);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.network.chat.MutableComponent");
                class_5250 displayName = (class_5250)object;
                String showdownId = BufferUtilsKt.readString((ByteBuf)buffer);
                List activePokemon = new ArrayList();
                int n3 = NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_BYTE);
                for (int k = 0; k < n3; ++k) {
                    int it3 = k;
                    boolean bl3 = false;
                    boolean bl4 = buffer.readBoolean() ? activePokemon.add(ActiveBattlePokemonDTO.Companion.loadFromBuffer(buffer)) : activePokemon.add(null);
                }
                ActorType type = ActorType.values()[NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_BYTE)];
                Intrinsics.checkNotNull((Object)uuid);
                actors.add(new BattleActorDTO(uuid, displayName, showdownId, activePokemon, type));
            }
            sides.add(new BattleSideDTO(actors));
        }
        this.setSide1((BattleSideDTO)sides.get(0));
        this.setSide2((BattleSideDTO)sides.get(1));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b/\b\u0086\b\u0018\u0000 F2\u00020\u0001:\u0001FBc\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b \u0010!J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020\rH\u00c6\u0003\u00a2\u0006\u0004\b(\u0010'J\u0010\u0010)\u001a\u00020\u0010H\u00c6\u0003\u00a2\u0006\u0004\b)\u0010*J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u00c6\u0003\u00a2\u0006\u0004\b+\u0010,J~\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u00c6\u0001\u00a2\u0006\u0004\b-\u0010.J\u001a\u00100\u001a\u00020\u00102\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b0\u00101J\u0010\u00102\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b2\u00103J\u0010\u00104\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b4\u00105R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00106\u001a\u0004\b7\u0010\u001dR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00108\u001a\u0004\b9\u0010\u001fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010:\u001a\u0004\b;\u0010!R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010<\u001a\u0004\b=\u0010#R\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010>\u001a\u0004\b?\u0010%R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010@\u001a\u0004\bA\u0010'R\u0017\u0010\u000f\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010@\u001a\u0004\bB\u0010'R\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010C\u001a\u0004\b\u0011\u0010*R#\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010D\u001a\u0004\bE\u0010,\u00a8\u0006G"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_5250;", "displayName", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "properties", "", "", "aspects", "Lcom/cobblemon/mod/common/pokemon/status/PersistentStatus;", "status", "", "hpValue", "maxHp", "", "isFlatHp", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "", "statChanges", "<init>", "(Ljava/util/UUID;Lnet/minecraft/class_5250;Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Ljava/util/Set;Lcom/cobblemon/mod/common/pokemon/status/PersistentStatus;FFZLjava/util/Map;)V", "Lnet/minecraft/class_9129;", "buffer", "saveToBuffer", "(Lnet/minecraft/class_9129;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "component1", "()Ljava/util/UUID;", "component2", "()Lnet/minecraft/class_5250;", "component3", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "component4", "()Ljava/util/Set;", "component5", "()Lcom/cobblemon/mod/common/pokemon/status/PersistentStatus;", "component6", "()F", "component7", "component8", "()Z", "component9", "()Ljava/util/Map;", "copy", "(Ljava/util/UUID;Lnet/minecraft/class_5250;Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Ljava/util/Set;Lcom/cobblemon/mod/common/pokemon/status/PersistentStatus;FFZLjava/util/Map;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getUuid", "Lnet/minecraft/class_5250;", "getDisplayName", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getProperties", "Ljava/util/Set;", "getAspects", "Lcom/cobblemon/mod/common/pokemon/status/PersistentStatus;", "getStatus", "F", "getHpValue", "getMaxHp", "Z", "Ljava/util/Map;", "getStatChanges", "Companion", "common"})
    @SourceDebugExtension(value={"SMAP\nBattleInitializePacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleInitializePacket.kt\ncom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
    public static final class ActiveBattlePokemonDTO {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final UUID uuid;
        @NotNull
        private final class_5250 displayName;
        @NotNull
        private final PokemonProperties properties;
        @NotNull
        private final Set<String> aspects;
        @Nullable
        private final PersistentStatus status;
        private final float hpValue;
        private final float maxHp;
        private final boolean isFlatHp;
        @NotNull
        private final Map<Stat, Integer> statChanges;

        public ActiveBattlePokemonDTO(@NotNull UUID uuid, @NotNull class_5250 displayName, @NotNull PokemonProperties properties, @NotNull Set<String> aspects2, @Nullable PersistentStatus status, float hpValue, float maxHp, boolean isFlatHp, @NotNull Map<Stat, Integer> statChanges) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter(aspects2, (String)"aspects");
            Intrinsics.checkNotNullParameter(statChanges, (String)"statChanges");
            this.uuid = uuid;
            this.displayName = displayName;
            this.properties = properties;
            this.aspects = aspects2;
            this.status = status;
            this.hpValue = hpValue;
            this.maxHp = maxHp;
            this.isFlatHp = isFlatHp;
            this.statChanges = statChanges;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final class_5250 getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final PokemonProperties getProperties() {
            return this.properties;
        }

        @NotNull
        public final Set<String> getAspects() {
            return this.aspects;
        }

        @Nullable
        public final PersistentStatus getStatus() {
            return this.status;
        }

        public final float getHpValue() {
            return this.hpValue;
        }

        public final float getMaxHp() {
            return this.maxHp;
        }

        public final boolean isFlatHp() {
            return this.isFlatHp;
        }

        @NotNull
        public final Map<Stat, Integer> getStatChanges() {
            return this.statChanges;
        }

        @NotNull
        public final ActiveBattlePokemonDTO saveToBuffer(@NotNull class_9129 buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.method_10797(this.uuid);
            class_8824.field_49668.encode((Object)buffer, (Object)this.displayName);
            BufferUtilsKt.writeString((ByteBuf)buffer, PokemonProperties.asString$default(this.properties, null, 1, null));
            buffer.method_34062((Collection)this.aspects, (arg_0, arg_1) -> ActiveBattlePokemonDTO.saveToBuffer$lambda$1(ActiveBattlePokemonDTO::saveToBuffer$lambda$0, arg_0, arg_1));
            buffer.method_52964(this.status != null);
            PersistentStatus persistentStatus = this.status;
            if (persistentStatus != null) {
                PersistentStatus it = persistentStatus;
                boolean bl = false;
                ByteBuf byteBuf = (ByteBuf)buffer;
                String string = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                BufferUtilsKt.writeString(byteBuf, string);
            }
            buffer.method_52941(this.hpValue);
            buffer.method_52941(this.maxHp);
            buffer.method_52964(this.isFlatHp);
            NetExtensionsKt.writeMapK((ByteBuf)buffer, IntSize.U_BYTE, this.statChanges, arg_0 -> ActiveBattlePokemonDTO.saveToBuffer$lambda$3(buffer, arg_0));
            return this;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final class_5250 component2() {
            return this.displayName;
        }

        @NotNull
        public final PokemonProperties component3() {
            return this.properties;
        }

        @NotNull
        public final Set<String> component4() {
            return this.aspects;
        }

        @Nullable
        public final PersistentStatus component5() {
            return this.status;
        }

        public final float component6() {
            return this.hpValue;
        }

        public final float component7() {
            return this.maxHp;
        }

        public final boolean component8() {
            return this.isFlatHp;
        }

        @NotNull
        public final Map<Stat, Integer> component9() {
            return this.statChanges;
        }

        @NotNull
        public final ActiveBattlePokemonDTO copy(@NotNull UUID uuid, @NotNull class_5250 displayName, @NotNull PokemonProperties properties, @NotNull Set<String> aspects2, @Nullable PersistentStatus status, float hpValue, float maxHp, boolean isFlatHp, @NotNull Map<Stat, Integer> statChanges) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter(aspects2, (String)"aspects");
            Intrinsics.checkNotNullParameter(statChanges, (String)"statChanges");
            return new ActiveBattlePokemonDTO(uuid, displayName, properties, aspects2, status, hpValue, maxHp, isFlatHp, statChanges);
        }

        public static /* synthetic */ ActiveBattlePokemonDTO copy$default(ActiveBattlePokemonDTO activeBattlePokemonDTO, UUID uUID, class_5250 class_52502, PokemonProperties pokemonProperties, Set set, PersistentStatus persistentStatus, float f, float f2, boolean bl, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = activeBattlePokemonDTO.uuid;
            }
            if ((n & 2) != 0) {
                class_52502 = activeBattlePokemonDTO.displayName;
            }
            if ((n & 4) != 0) {
                pokemonProperties = activeBattlePokemonDTO.properties;
            }
            if ((n & 8) != 0) {
                set = activeBattlePokemonDTO.aspects;
            }
            if ((n & 0x10) != 0) {
                persistentStatus = activeBattlePokemonDTO.status;
            }
            if ((n & 0x20) != 0) {
                f = activeBattlePokemonDTO.hpValue;
            }
            if ((n & 0x40) != 0) {
                f2 = activeBattlePokemonDTO.maxHp;
            }
            if ((n & 0x80) != 0) {
                bl = activeBattlePokemonDTO.isFlatHp;
            }
            if ((n & 0x100) != 0) {
                map = activeBattlePokemonDTO.statChanges;
            }
            return activeBattlePokemonDTO.copy(uUID, class_52502, pokemonProperties, set, persistentStatus, f, f2, bl, map);
        }

        @NotNull
        public String toString() {
            return "ActiveBattlePokemonDTO(uuid=" + this.uuid + ", displayName=" + this.displayName + ", properties=" + this.properties + ", aspects=" + this.aspects + ", status=" + this.status + ", hpValue=" + this.hpValue + ", maxHp=" + this.maxHp + ", isFlatHp=" + this.isFlatHp + ", statChanges=" + this.statChanges + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.displayName.hashCode();
            result = result * 31 + this.properties.hashCode();
            result = result * 31 + ((Object)this.aspects).hashCode();
            result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
            result = result * 31 + Float.hashCode(this.hpValue);
            result = result * 31 + Float.hashCode(this.maxHp);
            result = result * 31 + Boolean.hashCode(this.isFlatHp);
            result = result * 31 + ((Object)this.statChanges).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActiveBattlePokemonDTO)) {
                return false;
            }
            ActiveBattlePokemonDTO activeBattlePokemonDTO = (ActiveBattlePokemonDTO)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)activeBattlePokemonDTO.uuid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)activeBattlePokemonDTO.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.properties, (Object)activeBattlePokemonDTO.properties)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.aspects, activeBattlePokemonDTO.aspects)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.status, (Object)activeBattlePokemonDTO.status)) {
                return false;
            }
            if (Float.compare(this.hpValue, activeBattlePokemonDTO.hpValue) != 0) {
                return false;
            }
            if (Float.compare(this.maxHp, activeBattlePokemonDTO.maxHp) != 0) {
                return false;
            }
            if (this.isFlatHp != activeBattlePokemonDTO.isFlatHp) {
                return false;
            }
            return Intrinsics.areEqual(this.statChanges, activeBattlePokemonDTO.statChanges);
        }

        private static final Unit saveToBuffer$lambda$0(class_2540 buf, String it) {
            Intrinsics.checkNotNull((Object)buf);
            ByteBuf byteBuf = (ByteBuf)buf;
            Intrinsics.checkNotNull((Object)it);
            BufferUtilsKt.writeString(byteBuf, it);
            return Unit.INSTANCE;
        }

        private static final void saveToBuffer$lambda$1(Function2 $tmp0, Object object, String object2) {
            $tmp0.invoke(object, (Object)object2);
        }

        private static final Unit saveToBuffer$lambda$3(class_9129 $buffer, Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            Stat stat = (Stat)entry.getKey();
            int stages = ((Number)entry.getValue()).intValue();
            Cobblemon.INSTANCE.getStatProvider().encode($buffer, stat);
            NetExtensionsKt.writeSizedInt((ByteBuf)$buffer, IntSize.BYTE, stages);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "isAlly", "illusion", "Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "fromPokemon", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;ZLcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "mock", "fromMock", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;ZLcom/cobblemon/mod/common/api/pokemon/PokemonProperties;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "Lnet/minecraft/class_9129;", "buffer", "loadFromBuffer", "(Lnet/minecraft/class_9129;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "common"})
        @SourceDebugExtension(value={"SMAP\nBattleInitializePacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleInitializePacket.kt\ncom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ActiveBattlePokemonDTO fromPokemon(@NotNull BattlePokemon battlePokemon, boolean isAlly, @Nullable BattlePokemon illusion) {
                void $this$fromPokemon_u24lambda_u240;
                Object object;
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                Pokemon pokemon = battlePokemon.getEffectedPokemon();
                if (isAlly) {
                    object = pokemon;
                } else {
                    object = illusion;
                    if (object == null || (object = ((BattlePokemon)object).getEffectedPokemon()) == null) {
                        object = pokemon;
                    }
                }
                Object exposed = object;
                float hpValue = isAlly ? (float)pokemon.getCurrentHealth() : (float)pokemon.getCurrentHealth() / (float)pokemon.getMaxHealth();
                UUID uUID = ((Pokemon)exposed).getUuid();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
                Object object2 = new PokemonPropertyExtractor[]{PokemonPropertyExtractor.SPECIES, PokemonPropertyExtractor.GENDER, PokemonPropertyExtractor.FORM, PokemonPropertyExtractor.SHINY};
                Object object3 = object2 = ((Pokemon)exposed).createPokemonProperties((PokemonPropertyExtractor)object2);
                class_5250 class_52502 = Pokemon.getDisplayName$default((Pokemon)exposed, false, 1, null);
                UUID uUID2 = uUID;
                boolean bl = false;
                $this$fromPokemon_u24lambda_u240.setLevel(pokemon.getLevel());
                Unit unit = Unit.INSTANCE;
                PersistentStatusContainer persistentStatusContainer = pokemon.getStatus();
                Map<Stat, Integer> map = battlePokemon.getStatChanges();
                boolean bl2 = isAlly;
                float f = pokemon.getMaxHealth();
                float f2 = hpValue;
                PersistentStatus persistentStatus = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
                Set<String> set = ((Pokemon)exposed).getAspects();
                Object object4 = object2;
                class_5250 class_52503 = class_52502;
                UUID uUID3 = uUID2;
                return new ActiveBattlePokemonDTO(uUID3, class_52503, (PokemonProperties)object4, set, persistentStatus, f2, f, bl2, map);
            }

            public static /* synthetic */ ActiveBattlePokemonDTO fromPokemon$default(Companion companion, BattlePokemon battlePokemon, boolean bl, BattlePokemon battlePokemon2, int n, Object object) {
                if ((n & 4) != 0) {
                    battlePokemon2 = null;
                }
                return companion.fromPokemon(battlePokemon, bl, battlePokemon2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ActiveBattlePokemonDTO fromMock(@NotNull BattlePokemon battlePokemon, boolean isAlly, @NotNull PokemonProperties mock) {
                void $this$fromMock_u24lambda_u240;
                PokemonProperties pokemonProperties;
                Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
                Intrinsics.checkNotNullParameter((Object)mock, (String)"mock");
                Pokemon pokemon = battlePokemon.getEffectedPokemon();
                float hpValue = isAlly ? (float)pokemon.getCurrentHealth() : (float)pokemon.getCurrentHealth() / (float)pokemon.getMaxHealth();
                PokemonProperties pokemonProperties2 = pokemonProperties = mock;
                class_5250 class_52502 = Pokemon.getDisplayName$default(pokemon, false, 1, null);
                UUID uUID = battlePokemon.getUuid();
                boolean bl = false;
                $this$fromMock_u24lambda_u240.setLevel(pokemon.getLevel());
                Unit unit = Unit.INSTANCE;
                PersistentStatusContainer persistentStatusContainer = pokemon.getStatus();
                Map<Stat, Integer> map = battlePokemon.getStatChanges();
                boolean bl2 = isAlly;
                float f = pokemon.getMaxHealth();
                float f2 = hpValue;
                PersistentStatus persistentStatus = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
                Set<String> set = mock.getAspects();
                PokemonProperties pokemonProperties3 = pokemonProperties;
                class_5250 class_52503 = class_52502;
                UUID uUID2 = uUID;
                return new ActiveBattlePokemonDTO(uUID2, class_52503, pokemonProperties3, set, persistentStatus, f2, f, bl2, map);
            }

            @NotNull
            public final ActiveBattlePokemonDTO loadFromBuffer(@NotNull class_9129 buffer) {
                Status status;
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                UUID uuid = buffer.method_10790();
                class_5250 pokemonDisplayName = ((class_2561)class_8824.field_49668.decode((Object)buffer)).method_27661();
                PokemonProperties properties = PokemonProperties.Companion.parse$default(PokemonProperties.Companion, BufferUtilsKt.readString((ByteBuf)buffer), " ", null, 4, null);
                List list = buffer.method_34066(arg_0 -> Companion.loadFromBuffer$lambda$1(arg_0 -> Companion.loadFromBuffer$lambda$0(buffer, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
                Set aspects2 = CollectionsKt.toSet((Iterable)list);
                PersistentStatus status2 = buffer.readBoolean() ? ((status = Statuses.getStatus(BufferUtilsKt.readIdentifier((ByteBuf)buffer))) instanceof PersistentStatus ? (PersistentStatus)status : null) : null;
                float hpRatio = buffer.readFloat();
                float maxHp = buffer.readFloat();
                boolean isFlatHp = buffer.readBoolean();
                Map statChanges = new LinkedHashMap();
                NetExtensionsKt.readMapK((ByteBuf)buffer, IntSize.U_BYTE, statChanges, () -> Companion.loadFromBuffer$lambda$2(buffer));
                Intrinsics.checkNotNull((Object)uuid);
                Intrinsics.checkNotNull((Object)pokemonDisplayName);
                return new ActiveBattlePokemonDTO(uuid, pokemonDisplayName, properties, aspects2, status2, hpRatio, maxHp, isFlatHp, statChanges);
            }

            private static final String loadFromBuffer$lambda$0(class_9129 $buffer, class_2540 it) {
                return BufferUtilsKt.readString((ByteBuf)$buffer);
            }

            private static final String loadFromBuffer$lambda$1(Function1 $tmp0, Object object) {
                return (String)$tmp0.invoke(object);
            }

            private static final Pair loadFromBuffer$lambda$2(class_9129 $buffer) {
                Stat stat = Cobblemon.INSTANCE.getStatProvider().decode($buffer);
                int stages = NetExtensionsKt.readSizedInt((ByteBuf)$buffer, IntSize.BYTE);
                return TuplesKt.to((Object)stat, (Object)stages);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018JJ\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u0010\b\u0002\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010#\u001a\u0004\b$\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b&\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b(\u0010\u0014R\u001f\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010)\u001a\u0004\b*\u0010\u0016R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010+\u001a\u0004\b,\u0010\u0018\u00a8\u0006-"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleActorDTO;", "", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_5250;", "displayName", "", "showdownId", "", "Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$ActiveBattlePokemonDTO;", "activePokemon", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "type", "<init>", "(Ljava/util/UUID;Lnet/minecraft/class_5250;Ljava/lang/String;Ljava/util/List;Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;)V", "component1", "()Ljava/util/UUID;", "component2", "()Lnet/minecraft/class_5250;", "component3", "()Ljava/lang/String;", "component4", "()Ljava/util/List;", "component5", "()Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "copy", "(Ljava/util/UUID;Lnet/minecraft/class_5250;Ljava/lang/String;Ljava/util/List;Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleActorDTO;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/util/UUID;", "getUuid", "Lnet/minecraft/class_5250;", "getDisplayName", "Ljava/lang/String;", "getShowdownId", "Ljava/util/List;", "getActivePokemon", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "getType", "common"})
    public static final class BattleActorDTO {
        @NotNull
        private final UUID uuid;
        @NotNull
        private final class_5250 displayName;
        @NotNull
        private final String showdownId;
        @NotNull
        private final List<ActiveBattlePokemonDTO> activePokemon;
        @NotNull
        private final ActorType type;

        public BattleActorDTO(@NotNull UUID uuid, @NotNull class_5250 displayName, @NotNull String showdownId, @NotNull List<ActiveBattlePokemonDTO> activePokemon, @NotNull ActorType type) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)showdownId, (String)"showdownId");
            Intrinsics.checkNotNullParameter(activePokemon, (String)"activePokemon");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.uuid = uuid;
            this.displayName = displayName;
            this.showdownId = showdownId;
            this.activePokemon = activePokemon;
            this.type = type;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final class_5250 getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getShowdownId() {
            return this.showdownId;
        }

        @NotNull
        public final List<ActiveBattlePokemonDTO> getActivePokemon() {
            return this.activePokemon;
        }

        @NotNull
        public final ActorType getType() {
            return this.type;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final class_5250 component2() {
            return this.displayName;
        }

        @NotNull
        public final String component3() {
            return this.showdownId;
        }

        @NotNull
        public final List<ActiveBattlePokemonDTO> component4() {
            return this.activePokemon;
        }

        @NotNull
        public final ActorType component5() {
            return this.type;
        }

        @NotNull
        public final BattleActorDTO copy(@NotNull UUID uuid, @NotNull class_5250 displayName, @NotNull String showdownId, @NotNull List<ActiveBattlePokemonDTO> activePokemon, @NotNull ActorType type) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)showdownId, (String)"showdownId");
            Intrinsics.checkNotNullParameter(activePokemon, (String)"activePokemon");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new BattleActorDTO(uuid, displayName, showdownId, activePokemon, type);
        }

        public static /* synthetic */ BattleActorDTO copy$default(BattleActorDTO battleActorDTO, UUID uUID, class_5250 class_52502, String string, List list, ActorType actorType, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = battleActorDTO.uuid;
            }
            if ((n & 2) != 0) {
                class_52502 = battleActorDTO.displayName;
            }
            if ((n & 4) != 0) {
                string = battleActorDTO.showdownId;
            }
            if ((n & 8) != 0) {
                list = battleActorDTO.activePokemon;
            }
            if ((n & 0x10) != 0) {
                actorType = battleActorDTO.type;
            }
            return battleActorDTO.copy(uUID, class_52502, string, list, actorType);
        }

        @NotNull
        public String toString() {
            return "BattleActorDTO(uuid=" + this.uuid + ", displayName=" + this.displayName + ", showdownId=" + this.showdownId + ", activePokemon=" + this.activePokemon + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.displayName.hashCode();
            result = result * 31 + this.showdownId.hashCode();
            result = result * 31 + ((Object)this.activePokemon).hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BattleActorDTO)) {
                return false;
            }
            BattleActorDTO battleActorDTO = (BattleActorDTO)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)battleActorDTO.uuid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)battleActorDTO.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.showdownId, (Object)battleActorDTO.showdownId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.activePokemon, battleActorDTO.activePokemon)) {
                return false;
            }
            return this.type == battleActorDTO.type;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleSideDTO;", "", "", "Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleActorDTO;", "actors", "<init>", "(Ljava/util/List;)V", "component1", "()Ljava/util/List;", "copy", "(Ljava/util/List;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$BattleSideDTO;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getActors", "common"})
    public static final class BattleSideDTO {
        @NotNull
        private final List<BattleActorDTO> actors;

        public BattleSideDTO(@NotNull List<BattleActorDTO> actors) {
            Intrinsics.checkNotNullParameter(actors, (String)"actors");
            this.actors = actors;
        }

        @NotNull
        public final List<BattleActorDTO> getActors() {
            return this.actors;
        }

        @NotNull
        public final List<BattleActorDTO> component1() {
            return this.actors;
        }

        @NotNull
        public final BattleSideDTO copy(@NotNull List<BattleActorDTO> actors) {
            Intrinsics.checkNotNullParameter(actors, (String)"actors");
            return new BattleSideDTO(actors);
        }

        public static /* synthetic */ BattleSideDTO copy$default(BattleSideDTO battleSideDTO, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = battleSideDTO.actors;
            }
            return battleSideDTO.copy(list);
        }

        @NotNull
        public String toString() {
            return "BattleSideDTO(actors=" + this.actors + ")";
        }

        public int hashCode() {
            return ((Object)this.actors).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BattleSideDTO)) {
                return false;
            }
            BattleSideDTO battleSideDTO = (BattleSideDTO)other;
            return Intrinsics.areEqual(this.actors, battleSideDTO.actors);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_9129;", "buffer", "Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket;", "decode", "(Lnet/minecraft/class_9129;)Lcom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket;", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "common"})
    @SourceDebugExtension(value={"SMAP\nBattleInitializePacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleInitializePacket.kt\ncom/cobblemon/mod/common/net/messages/client/battle/BattleInitializePacket$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        @NotNull
        public final BattleInitializePacket decode(@NotNull class_9129 buffer) {
            BattleInitializePacket battleInitializePacket;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            BattleInitializePacket $this$decode_u24lambda_u240 = battleInitializePacket = new BattleInitializePacket();
            boolean bl = false;
            $this$decode_u24lambda_u240.decode(buffer);
            return battleInitializePacket;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

