/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.DoubleJump;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.Seat;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.duck.PlayerDuck;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.orientation.ServerboundUpdateOrientationPacket;
import com.cobblemon.mod.common.net.messages.server.riding.ServerboundUpdateDriverInputPacket;
import com.cobblemon.mod.common.net.messages.server.riding.ServerboundUpdateRiderRotationPacket;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_746.class})
public abstract class LocalPlayerMixin
extends class_742
implements OrientationControllable,
DoubleJump {
    @Unique
    Matrix3f cobblemon$lastOrientation;
    @Unique
    float cobblemon$lastRideXRot;
    @Unique
    float cobblemon$lastRideYRot;
    @Unique
    class_243 cobblemon$lastRideEyePos;
    @Unique
    boolean cobblemon$isDoubleJumping = false;
    @Shadow
    private float field_3922;
    @Shadow
    public class_744 field_3913;
    @Shadow
    private int field_3934;
    @Unique
    private int cobblemon$survivalJumpTriggerTime;
    @Unique
    private boolean cobblemon$isJumping;

    public LocalPlayerMixin(class_638 clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V")})
    private void cobblemon$updateRotationMatrixPassenger(CallbackInfo ci) {
        class_1297 class_12972 = this.method_5854();
        if (!(class_12972 instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)class_12972;
        OrientationController vehicleController = controllableVehicle.getOrientationController();
        if (!vehicleController.isActive() || vehicleController.getOrientation() == this.cobblemon$lastOrientation) {
            return;
        }
        this.cobblemon$lastOrientation = vehicleController.getOrientation() != null ? new Matrix3f((Matrix3fc)vehicleController.getOrientation()) : null;
        CobblemonNetwork.sendToServer(new ServerboundUpdateOrientationPacket(this.method_5854().method_5628(), vehicleController.getOrientation()));
    }

    @Inject(method={"rideTick"}, at={@At(value="HEAD")})
    private void cobblemon$updateOrientationControllerRideTick(CallbackInfo ci) {
        if (class_310.method_1551().field_1724 != this) {
            return;
        }
        class_746 driver = (class_746)this;
        class_1297 vehicle = driver.method_5854();
        class_1297 class_12972 = this.method_5854();
        if (!(class_12972 instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)class_12972;
        boolean shouldUseCustomOrientation = this.cobblemon$shouldUseCustomOrientation((class_746)this);
        OrientationController vehicleController = controllableVehicle.getOrientationController();
        if (!vehicleController.isActive() && shouldUseCustomOrientation) {
            RidePassenger playerRotater = (RidePassenger)driver;
            playerRotater.cobblemon$setRideXRot(class_3532.method_15393((float)(driver.method_36455() - vehicle.method_36455())));
            playerRotater.cobblemon$setRideYRot(class_3532.method_15393((float)(driver.method_36454() - vehicle.method_36454())));
        }
        vehicleController.setActive(shouldUseCustomOrientation);
    }

    @Inject(method={"rideTick"}, at={@At(value="HEAD")})
    private void cobblemon$updateDriverInputRideTick(CallbackInfo ci) {
        if (class_310.method_1551().field_1724 != this) {
            return;
        }
        class_1297 class_12972 = this.method_5854();
        if (!(class_12972 instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)class_12972;
        float vertInput = this.field_6282 ? 1.0f : (this.method_5715() ? -1.0f : 0.0f);
        Vector3f driverInput = new Vector3f(Math.signum(this.field_6212), vertInput, Math.signum(this.field_6250));
        Vector3f lastSentDriverInput = ((PlayerDuck)((Object)this)).getLastSentDriverInput();
        if (driverInput.equals((Object)lastSentDriverInput)) {
            return;
        }
        ((PlayerDuck)((Object)this)).setLastSentDriverInput(driverInput);
        CobblemonNetwork.sendToServer(new ServerboundUpdateDriverInputPacket(driverInput));
    }

    @Inject(method={"rideTick"}, at={@At(value="HEAD")})
    private void cobblemon$updateRiderRotationsRideTick(CallbackInfo ci) {
        if (class_310.method_1551().field_1724 != this) {
            return;
        }
        class_1297 class_12972 = this.method_5854();
        if (!(class_12972 instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)class_12972;
        class_746 passenger = (class_746)this;
        RidePassenger playerRotater = (RidePassenger)passenger;
        float rideXRot = playerRotater.cobblemon$getRideXRot();
        float rideYRot = playerRotater.cobblemon$getRideYRot();
        class_243 rideEyePos = playerRotater.cobblemon$getRideEyePos();
        if (this.cobblemon$lastRideXRot != rideXRot || this.cobblemon$lastRideYRot != rideYRot || this.cobblemon$lastRideEyePos != rideEyePos) {
            this.cobblemon$lastRideXRot = rideXRot;
            this.cobblemon$lastRideYRot = rideYRot;
            this.cobblemon$lastRideEyePos = rideEyePos;
            CobblemonNetwork.sendToServer(new ServerboundUpdateRiderRotationPacket(rideXRot, rideYRot, rideEyePos));
        }
    }

    @Unique
    private boolean cobblemon$shouldUseCustomOrientation(class_746 player) {
        class_1297 playerVehicle = player.method_5854();
        if (playerVehicle == null) {
            return false;
        }
        if (!(playerVehicle instanceof PokemonEntity)) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)playerVehicle;
        return pokemonEntity.ifRidingAvailableSupply(false, (behaviour, settings, state) -> behaviour.shouldRoll(settings, state, pokemonEntity));
    }

    public void method_5848() {
        super.method_5848();
        if (class_310.method_1551().field_1724 != this) {
            return;
        }
        LocalPlayerMixin localPlayerMixin = this;
        if (!(localPlayerMixin instanceof OrientationControllable)) {
            return;
        }
        LocalPlayerMixin controllableVehicle = localPlayerMixin;
        controllableVehicle.getOrientationController().setActive(false);
    }

    @Inject(method={"getJumpRidingScale"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyJumpRidingScale(CallbackInfoReturnable<Float> cir) {
        PokemonEntity pokemonEntity;
        Float rideValue;
        class_1297 class_12972;
        class_746 player = (class_746)this;
        if (player.method_5765() && (class_12972 = player.method_5854()) instanceof PokemonEntity && (rideValue = (Float)(pokemonEntity = (PokemonEntity)class_12972).ifRidingAvailableSupply(null, (behaviour, settings, state) -> {
            if (behaviour.canJump(settings, state, pokemonEntity, (class_1657)player)) {
                return null;
            }
            return Float.valueOf(behaviour.setRideBar(settings, state, pokemonEntity, (class_1657)player));
        })) != null) {
            cir.setReturnValue((Object)rideValue);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void cobblemon$aiStep(CallbackInfo ci) {
        this.cobblemon$isDoubleJumping = false;
        this.cobblemon$isJumping = this.field_3913.field_3904;
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isSprinting()Z", shift=At.Shift.BEFORE)})
    private void cobblemon$updateDoubleJumping(CallbackInfo ci) {
        if (!this.cobblemon$isJumping && this.field_3913.field_3904 && this.field_3934 <= 0 && !this.method_5681()) {
            if (this.cobblemon$survivalJumpTriggerTime != 0) {
                this.cobblemon$isDoubleJumping = true;
                this.cobblemon$survivalJumpTriggerTime = 0;
            } else {
                this.cobblemon$survivalJumpTriggerTime = 12;
            }
        } else if (this.cobblemon$survivalJumpTriggerTime > 0) {
            --this.cobblemon$survivalJumpTriggerTime;
        }
    }

    @Override
    public boolean isDoubleJumping() {
        return this.cobblemon$isDoubleJumping;
    }

    @Inject(method={"isHandsBusy"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$isHandsBusy(CallbackInfoReturnable<Boolean> cir) {
        class_1297 vehicle = this.method_5854();
        if (vehicle instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)vehicle;
            int seatIndex = pokemonEntity.method_5685().indexOf(this);
            Seat seat = pokemonEntity.getSeats().get(seatIndex);
            cir.setReturnValue((Object)seat.getHandsBusy());
        }
    }

    public class_239 method_5745(double hitDistance, float partialTicks, boolean hitFluids) {
        class_1297 vehicle = this.method_5854();
        if (vehicle instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)vehicle;
            class_746 passenger = (class_746)this;
            RidePassenger playerRotater = (RidePassenger)passenger;
            class_243 eyePosition = playerRotater.cobblemon$getRideEyePos();
            class_243 viewVector = this.method_5828(partialTicks);
            class_243 viewDistanceVector = eyePosition.method_1031(viewVector.field_1352 * hitDistance, viewVector.field_1351 * hitDistance, viewVector.field_1350 * hitDistance);
            return this.method_37908().method_17742(new class_3959(eyePosition, viewDistanceVector, class_3959.class_3960.field_17559, hitFluids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)this));
        }
        return super.method_5745(hitDistance, partialTicks, hitFluids);
    }

    @Unique
    @NotNull
    private static Vector3f cobblemon$getFirstPersonOffset(PosableModel model, String locatorName) {
        Map<String, class_243> cameraOffsets = model.getFirstPersonCameraOffset();
        if (cameraOffsets.containsKey(locatorName)) {
            return cameraOffsets.get(locatorName).method_46409();
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }
}

