/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.PlayerSpawnerAccessor;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawnerFactory;
import com.cobblemon.mod.common.api.stats.CobblemonStats;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
implements PlayerSpawnerAccessor {
    @Unique
    public PlayerSpawner cobblemon$spawner;

    @Shadow
    public abstract class_3218 method_51469();

    @Override
    public PlayerSpawner getPlayerSpawner() {
        class_3222 player = (class_3222)this;
        if (this.cobblemon$spawner == null) {
            this.cobblemon$spawner = PlayerSpawnerFactory.INSTANCE.create(player);
        }
        return this.cobblemon$spawner;
    }

    @Override
    public void setPlayerSpawner(PlayerSpawner spawner) {
        this.cobblemon$spawner = spawner;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void cobblemon$tickSpawner(CallbackInfo ci) {
        if (!Cobblemon.config.getEnableSpawning()) {
            return;
        }
        if (!this.method_51469().method_8450().method_8355(CobblemonGameRules.DO_POKEMON_SPAWNING)) {
            return;
        }
        this.getPlayerSpawner().tick();
    }

    @Inject(method={"rideTick"}, at={@At(value="HEAD")})
    private void cobblemon$updateOrientationControllerRideTick(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        class_1297 vehicle = player.method_5854();
        if (!(vehicle instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)vehicle;
        boolean shouldUseCustomOrientation = this.cobblemon$shouldUseCustomOrientation(vehicle);
        controllableVehicle.getOrientationController().setActive(shouldUseCustomOrientation);
    }

    @Unique
    private boolean cobblemon$shouldUseCustomOrientation(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof PokemonEntity)) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        return pokemonEntity.ifRidingAvailableSupply(false, (behaviour, settings, state) -> behaviour.shouldRoll(settings, state, pokemonEntity));
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")})
    public void cobblemon$resetOrientationOnDismount(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        class_1297 class_12972 = player.method_5854();
        if (!(class_12972 instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)class_12972;
        controllableVehicle.getOrientationController().setActive(false);
    }

    @ModifyExpressionValue(method={"addAdditionalSaveData"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hasExactlyOnePlayerPassenger()Z")})
    private boolean cobblemon$cancelSavingPokemonMounts(boolean original, @Local(ordinal=0) class_1297 entity) {
        return original && !(entity instanceof PokemonEntity);
    }

    @WrapOperation(method={"checkRidingStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getVehicle()Lnet/minecraft/world/entity/Entity;")})
    public class_1297 cobblemon$checkRidingStatistics(class_3222 player, Operation<class_1297> original, @Local int distance) {
        CobblemonStats.CobblemonStat stat;
        class_1297 entity = (class_1297)original.call(new Object[]{player});
        if (!(entity instanceof PokemonEntity)) {
            return entity;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        RidingController ridingController = pokemonEntity.getRidingController();
        if (ridingController == null) {
            return entity;
        }
        ActiveRidingContext activeContext = ridingController.getContext();
        if (activeContext == null) {
            return entity;
        }
        RidingStyle ridingStyle = activeContext.getStyle();
        switch (ridingStyle) {
            case LAND: {
                CobblemonStats.CobblemonStat cobblemonStat = CobblemonStats.RIDING_LAND;
                break;
            }
            case AIR: {
                CobblemonStats.CobblemonStat cobblemonStat = CobblemonStats.RIDING_AIR;
                break;
            }
            case LIQUID: {
                CobblemonStats.CobblemonStat cobblemonStat = CobblemonStats.RIDING_LIQUID;
                break;
            }
            default: {
                CobblemonStats.CobblemonStat cobblemonStat = stat = null;
            }
        }
        if (stat != null) {
            player.method_7339(CobblemonStats.getStat(stat), distance);
        }
        return entity;
    }
}

