/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.PickUpItemTask;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.ai.ObtainableItem;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0015J'\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u001f\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/EatHeldItemTask;", "Lnet/minecraft/class_4097;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/class_3218;", "world", "", "checkExtraStartConditions", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "time", "canStillUse", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "Lnet/minecraft/class_1799;", "item", "canEat", "(Lnet/minecraft/class_1799;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "start", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "level", "gameTime", "stop", "tick", "Lnet/minecraft/class_1309;", "itemStack", "spawnFoodParticles", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_1799;)V", "timelastEaten", "J", "", "Lcom/cobblemon/mod/common/pokemon/ai/ObtainableItem;", "pickupItems", "Ljava/util/List;", "getPickupItems", "()Ljava/util/List;", "Companion", "common"})
public final class EatHeldItemTask
extends class_4097<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long timelastEaten;
    @NotNull
    private final List<ObtainableItem> pickupItems;
    private static final int MAX_DURATION = 60;
    private static final int COOLDOWN = 120;

    public EatHeldItemTask(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457));
        this.pickupItems = MoLangExtensionsKt.getObjectList(entity.getConfig(), "pickup_items");
    }

    @NotNull
    public final List<ObtainableItem> getPickupItems() {
        return this.pickupItems;
    }

    protected boolean checkExtraStartConditions(@NotNull class_3218 world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.timelastEaten + (long)120 > world.method_8510()) {
            return false;
        }
        class_1799 itemStack = entity.getPokemon().heldItem();
        return !itemStack.method_7960() && this.canEat(itemStack, entity) && !entity.isBusy();
    }

    protected boolean canStillUse(@NotNull class_3218 world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return !entity.getPokemon().getHeldItem$common().method_7960() && !entity.getPokemon().isFull() && !entity.isBusy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canEat(class_1799 item, PokemonEntity entity) {
        if (item.method_57826(class_9334.field_50075)) return true;
        Collection collection = this.pickupItems;
        class_5455 class_54552 = entity.method_56673();
        Intrinsics.checkNotNullExpressionValue((Object)class_54552, (String)"registryAccess(...)");
        ObtainableItem obtainableItem = MiscUtilsKt.findMatchingEntry(collection, class_54552, item);
        if (obtainableItem == null) return false;
        ExpressionLike expressionLike = obtainableItem.getOnUseEffect();
        if (expressionLike == null) return false;
        return true;
    }

    protected void start(@NotNull class_3218 world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.timelastEaten = time;
        entity.method_18868().method_18878(CobblemonMemories.IS_CONSUMING_ITEM, (Object)true);
    }

    protected void stop(@NotNull class_3218 level, @NotNull PokemonEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.method_18868().method_18875(CobblemonMemories.IS_CONSUMING_ITEM);
    }

    protected void tick(@NotNull class_3218 world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!world.field_9236 && entity.method_5805()) {
            class_1799 itemStack = entity.getPokemon().heldItem();
            Collection collection = this.pickupItems;
            class_5455 class_54552 = entity.method_56673();
            Intrinsics.checkNotNullExpressionValue((Object)class_54552, (String)"registryAccess(...)");
            ObtainableItem itemConfig = MiscUtilsKt.findMatchingEntry(collection, class_54552, itemStack);
            if (this.canEat(itemStack, entity)) {
                if (this.timelastEaten + (long)60 <= time) {
                    ExpressionLike onUseEffect;
                    class_2960 configuredReturnItem;
                    class_1799 resultItemStack = itemStack.method_7910((class_1937)world, (class_1309)entity);
                    ObtainableItem obtainableItem = itemConfig;
                    Object object = configuredReturnItem = obtainableItem != null ? obtainableItem.getReturnItem() : null;
                    resultItemStack = !Intrinsics.areEqual((Object)configuredReturnItem, (Object)class_1799.field_8037) ? new class_1799((class_1935)class_7923.field_41178.method_10223(configuredReturnItem)) : (Intrinsics.areEqual((Object)resultItemStack.method_7909(), (Object)itemStack.method_7909()) ? class_1799.field_8037 : resultItemStack);
                    Pokemon pokemon = entity.getPokemon();
                    class_1799 class_17992 = resultItemStack;
                    Intrinsics.checkNotNull((Object)class_17992);
                    Pokemon.swapHeldItem$default(pokemon, class_17992, false, false, 6, null);
                    ObtainableItem obtainableItem2 = itemConfig;
                    ExpressionLike expressionLike = onUseEffect = obtainableItem2 != null ? obtainableItem2.getOnUseEffect() : null;
                    if (onUseEffect != null) {
                        MoLangExtensionsKt.withQueryValue(MoLangExtensionsKt.getMainThreadRuntime(), "entity", MoLangFunctions.INSTANCE.asMostSpecificMoLangValue((class_1297)entity));
                        MoLangExtensionsKt.resolve$default(MoLangExtensionsKt.getMainThreadRuntime(), onUseEffect, null, 2, null);
                    }
                    this.timelastEaten = time;
                    if (itemConfig != null && itemConfig.getFullnessValue() > 0) {
                        entity.getPokemon().feedPokemon(itemConfig.getFullnessValue(), false);
                    }
                    resultItemStack = entity.getPokemon().heldItem();
                    Collection collection2 = this.pickupItems;
                    class_5455 class_54553 = entity.method_56673();
                    Intrinsics.checkNotNullExpressionValue((Object)class_54553, (String)"registryAccess(...)");
                    ObtainableItem obtainableItem3 = MiscUtilsKt.findMatchingEntry(collection2, class_54553, resultItemStack);
                    if ((obtainableItem3 != null ? obtainableItem3.getPickupPriority() : 0) < 0 && !(resultItemStack = Pokemon.swapHeldItem$default(entity.getPokemon(), resultItemStack, false, false, 6, null)).method_7960() && !entity.method_37908().field_9236) {
                        PickUpItemTask.INSTANCE.dropItem((class_1297)entity, resultItemStack);
                    }
                } else {
                    ObtainableItem obtainableItem = itemConfig;
                    if ((obtainableItem != null ? obtainableItem.getFullnessValue() : 0) > 0 && this.timelastEaten > 0L && entity.method_59922().method_43057() < 0.4f) {
                        entity.method_5783(entity.method_18869(itemStack), 1.0f, 1.0f);
                        world.method_8421((class_1297)entity, (byte)45);
                        this.spawnFoodParticles((class_1309)entity, itemStack);
                    }
                }
            }
        }
    }

    private final void spawnFoodParticles(class_1309 entity, class_1799 itemStack) {
        class_1937 class_19372 = entity.method_37908();
        Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        class_3218 serverLevel = (class_3218)class_19372;
        serverLevel.method_14199((class_2394)new class_2392(class_2398.field_11218, itemStack), entity.method_23317(), entity.method_23318() + 0.5, entity.method_23321(), 5, 0.1, 0.1, 0.1, 0.05);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/EatHeldItemTask$Companion;", "", "<init>", "()V", "", "MAX_DURATION", "I", "COOLDOWN", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

