/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon;

import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.struct.QueryStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.entity.PokemonSender;
import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.entity.pokemon.MocKEffect;
import com.cobblemon.mod.common.api.mark.Mark;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.TickingSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.api.riding.Seat;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.SentOutState;
import com.cobblemon.mod.common.pokemon.ai.MoveBehaviour;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0015\u0010\u000eJ\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\bJ\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u0006\u00a2\u0006\u0004\b\"\u0010\u0003J\u001b\u0010%\u001a\u00020\u00062\n\u0010$\u001a\u0006\u0012\u0002\b\u00030#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b'\u0010\u001aJ\r\u0010(\u001a\u00020\u0006\u00a2\u0006\u0004\b(\u0010\u0003J\r\u0010)\u001a\u00020\u0006\u00a2\u0006\u0004\b)\u0010\u0003J\u0019\u0010,\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020\u0006\u00a2\u0006\u0004\b.\u0010\u0003J\u000f\u0010/\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b/\u0010\u0003J\u001f\u00104\u001a\u00020\u00062\u0006\u00101\u001a\u0002002\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b4\u00105R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0018\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010\u001aR\"\u0010:\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0016\u0010C\u001a\u0004\u0018\u00010@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/PokemonServerDelegate;", "Lcom/cobblemon/mod/common/api/entity/PokemonSideDelegate;", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "changePokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "updatePathfindingPenalties", "updateAttributes", "", "max_hp", "maxHpToMaxHealthCurve", "(I)I", "defense", "Lkotlin/Pair;", "", "defenceToArmourCurve", "(I)Lkotlin/Pair;", "attack", "attackToDamageCurve", "updateHealth", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "initialize", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lcom/bedrockk/molang/runtime/struct/QueryStruct;", "struct", "addToStruct", "(Lcom/bedrockk/molang/runtime/struct/QueryStruct;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "getBattle", "()Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "updateTrackedValues", "Lnet/minecraft/class_2940;", "data", "onSyncedDataUpdated", "(Lnet/minecraft/class_2940;)V", "tick", "updateShownItem", "updatePoseType", "Lnet/minecraft/class_1282;", "source", "drop", "(Lnet/minecraft/class_1282;)V", "doDeathDrops", "updatePostDeath", "Lnet/minecraft/class_1297;", "passenger", "Lnet/minecraft/class_1297$class_4738;", "positionUpdater", "positionRider", "(Lnet/minecraft/class_1297;Lnet/minecraft/class_1297$class_4738;)V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "setEntity", "acknowledgedHPValue", "I", "getAcknowledgedHPValue", "()I", "setAcknowledgedHPValue", "(I)V", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getMock", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "mock", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonServerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonServerDelegate.kt\ncom/cobblemon/mod/common/entity/pokemon/PokemonServerDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,479:1\n1#2:480\n188#3,3:481\n*S KotlinDebug\n*F\n+ 1 PokemonServerDelegate.kt\ncom/cobblemon/mod/common/entity/pokemon/PokemonServerDelegate\n*L\n265#1:481,3\n*E\n"})
public final class PokemonServerDelegate
implements PokemonSideDelegate {
    public PokemonEntity entity;
    private int acknowledgedHPValue = -1;

    @NotNull
    public final PokemonEntity getEntity() {
        PokemonEntity pokemonEntity = this.entity;
        if (pokemonEntity != null) {
            return pokemonEntity;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"entity");
        return null;
    }

    public final void setEntity(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"<set-?>");
        this.entity = pokemonEntity;
    }

    public final int getAcknowledgedHPValue() {
        return this.acknowledgedHPValue;
    }

    public final void setAcknowledgedHPValue(int n) {
        this.acknowledgedHPValue = n;
    }

    private final PokemonProperties getMock() {
        MocKEffect mocKEffect = this.getEntity().getEffects().getMockEffect();
        return mocKEffect != null ? mocKEffect.getMock() : null;
    }

    @Override
    public void changePokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        this.updatePathfindingPenalties(pokemon);
        this.updateAttributes(pokemon);
        this.updateHealth(pokemon);
        MoLangFunctions.INSTANCE.addPokemonFunctions(this.getEntity().getStruct(), pokemon);
        MoLangFunctions.INSTANCE.addPokemonEntityFunctions(this.getEntity().getStruct(), this.getEntity());
    }

    public final void updatePathfindingPenalties(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        MoveBehaviour moving = pokemon.getForm().getBehaviour().getMoving();
        this.getEntity().method_5941(class_7.field_14, moving.getSwim().getCanSwimInLava() ? 12.0f : -1.0f);
        this.getEntity().method_5941(class_7.field_18, moving.getSwim().getCanSwimInWater() ? 12.0f : -1.0f);
        this.getEntity().method_5941(class_7.field_4, moving.getSwim().getCanSwimInWater() || moving.getWalk().getAvoidsLand() || moving.getSwim().getCanBreatheUnderwater() ? 6.0f : -1.0f);
        if (moving.getSwim().getCanBreatheUnderwater()) {
            this.getEntity().method_5941(class_7.field_18, 0.0f);
        }
        if (moving.getSwim().getCanBreatheUnderlava()) {
            this.getEntity().method_5941(class_7.field_14, moving.getSwim().getCanSwimInLava() ? 0.0f : -1.0f);
        }
        if (moving.getWalk().getAvoidsLand()) {
            this.getEntity().method_5941(class_7.field_12, 12.0f);
        }
        if (moving.getWalk().getCanWalk() && moving.getFly().getCanFly()) {
            this.getEntity().method_5941(class_7.field_12, 0.0f);
        }
        this.getEntity().getNavigation().setCanPathThroughFire(this.getEntity().method_5753());
    }

    public final void updateAttributes(@NotNull Pokemon pokemon) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            this.getEntity().method_6012();
            if (Intrinsics.areEqual((Object)pokemon.getAbility().getName(), (Object)"levitate")) {
                class_1324 class_13242 = this.getEntity().method_5996(class_5134.field_49078);
                if (class_13242 != null) {
                    class_13242.method_6192(0.04);
                }
            }
            double maxHealth = this.maxHpToMaxHealthCurve(pokemon.getMaxHealth());
            class_1324 class_13243 = this.getEntity().method_5996(class_5134.field_23716);
            if (class_13243 != null) {
                class_13243.method_6192(maxHealth);
            }
            Pair<Double, Double> pair = this.defenceToArmourCurve(pokemon.getDefence());
            double armour = ((Number)pair.component1()).doubleValue();
            double toughness = ((Number)pair.component2()).doubleValue();
            class_1324 class_13244 = this.getEntity().method_5996(class_5134.field_23724);
            if (class_13244 != null) {
                class_13244.method_6192(armour);
            }
            class_1324 class_13245 = this.getEntity().method_5996(class_5134.field_23725);
            if (class_13245 != null) {
                class_13245.method_6192(toughness);
            }
            double attackDamage = this.attackToDamageCurve(pokemon.getAttack());
            class_1324 class_13246 = this.getEntity().method_5996(class_5134.field_23721);
            if (class_13246 == null) break block5;
            class_13246.method_6192(attackDamage);
        }
    }

    public final int maxHpToMaxHealthCurve(int max_hp) {
        int n;
        if (max_hp <= 1) {
            n = 1;
        } else if (max_hp < 12) {
            n = 6;
        } else {
            double max_hp_d = max_hp;
            n = MathKt.roundToInt((double)Math.sqrt(Math.pow(max_hp_d, 1.402)));
        }
        return n;
    }

    @NotNull
    public final Pair<Double, Double> defenceToArmourCurve(int defense) {
        double armour = defense < 200 ? 0.0 : Math.min(30.0, Math.rint((double)(defense - 200) / 10.0));
        double toughness = defense < 300 ? 0.0 : Math.min(20.0, Math.rint((double)(defense - 300) / 7.5));
        return TuplesKt.to((Object)armour, (Object)toughness);
    }

    public final int attackToDamageCurve(int attack) {
        int damage = attack < 10 ? 1 : (int)Math.ceil(Math.sqrt(Math.pow(attack - 10, 0.875)));
        return RangesKt.coerceAtLeast((int)damage, (int)1);
    }

    public final void updateHealth(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (this.acknowledgedHPValue != pokemon.getCurrentHealth()) {
            this.acknowledgedHPValue = pokemon.getCurrentHealth();
            if (pokemon.getCurrentHealth() <= 0) {
                this.getEntity().method_6033(0.0f);
            } else {
                float currentHPRatio = (float)pokemon.getCurrentHealth() / (float)pokemon.getMaxHealth();
                if (Math.abs(currentHPRatio) <= Float.MAX_VALUE) {
                    this.getEntity().method_6033((float)Math.ceil(this.getEntity().method_6063() * currentHPRatio));
                }
            }
        }
    }

    @Override
    public void initialize(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.setEntity(entity);
        PokemonEntity $this$initialize_u24lambda_u240 = entity;
        boolean bl = false;
        $this$initialize_u24lambda_u240.method_6125(0.1f);
        entity.getDespawner().beginTracking((PokemonEntity)((class_1297)$this$initialize_u24lambda_u240));
        $this$initialize_u24lambda_u240.initializeScripting();
        this.updateTrackedValues();
    }

    @Override
    public void addToStruct(@NotNull QueryStruct struct2) {
        Intrinsics.checkNotNullParameter((Object)struct2, (String)"struct");
        PokemonSideDelegate.super.addToStruct(struct2);
        if (this.getEntity().getPokemon().isWild()) {
            struct2.addFunction("attempt_wild_battle", arg_0 -> PokemonServerDelegate.addToStruct$lambda$0(this, arg_0));
        }
    }

    @Nullable
    public final PokemonBattle getBattle() {
        PokemonBattle pokemonBattle;
        UUID uUID = this.getEntity().getBattleId();
        if (uUID != null) {
            UUID p0 = uUID;
            boolean bl = false;
            pokemonBattle = BattleRegistry.getBattle(p0);
        } else {
            pokemonBattle = null;
        }
        return pokemonBattle;
    }

    public final void updateTrackedValues() {
        block18: {
            Map<RidingStat, Float> newRideBoosts;
            block17: {
                boolean bl;
                block16: {
                    Object object;
                    Set<String> trackedAspects;
                    Object object2 = this.getMock();
                    if (object2 == null || (object2 = ((PokemonProperties)object2).getSpecies()) == null) {
                        String string = this.getEntity().getPokemon().getSpecies().getResourceIdentifier().toString();
                        object2 = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    }
                    Object trackedSpecies = object2;
                    PokemonProperties pokemonProperties = this.getMock();
                    if ((pokemonProperties == null || (pokemonProperties = pokemonProperties.getNickname()) == null) && (pokemonProperties = this.getEntity().getPokemon().getNickname()) == null) {
                        pokemonProperties = class_2561.method_43473();
                    }
                    PokemonProperties trackedNickname = pokemonProperties;
                    Mark mark = this.getEntity().getPokemon().getActiveMark();
                    String trackedMark = String.valueOf(mark != null ? mark.getIdentifier() : null);
                    Object object3 = this.getMock();
                    if (object3 == null || (object3 = ((PokemonProperties)object3).getAspects()) == null) {
                        object3 = trackedAspects = this.getEntity().getPokemon().getAspects();
                    }
                    if ((object = this.getMock()) == null || (object = ((PokemonProperties)object).getPokeball()) == null) {
                        String string = this.getEntity().getPokemon().getCaughtBall().getName().toString();
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    }
                    Object trackedBall = object;
                    Object object4 = this.getMock();
                    float trackedScaleModifier = object4 != null && (object4 = ((PokemonProperties)object4).getScaleModifier()) != null ? ((Float)object4).floatValue() : this.getEntity().getPokemon().getScaleModifier();
                    this.getEntity().method_6174(this.getEntity().getPokemon().getOwnerUUID());
                    this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getSPECIES(), trackedSpecies);
                    if (!Intrinsics.areEqual((Object)this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getNICKNAME()), (Object)trackedNickname)) {
                        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getNICKNAME(), (Object)trackedNickname);
                    }
                    if (!Intrinsics.areEqual((Object)this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getMARK()), (Object)trackedMark)) {
                        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getMARK(), (Object)trackedMark);
                    }
                    this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getASPECTS(), trackedAspects);
                    this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getLABEL_LEVEL(), (Object)this.getEntity().getPokemon().getLevel());
                    if (PoseType.Companion.getFLYING_POSES().contains((Object)this.getEntity().getCurrentPoseType())) {
                        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getMOVING(), (Object)this.getEntity().isPokemonFlying());
                    } else {
                        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getMOVING(), (Object)this.getEntity().isPokemonWalking());
                    }
                    this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getFRIENDSHIP(), (Object)this.getEntity().getPokemon().getFriendship());
                    this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getCAUGHT_BALL(), trackedBall);
                    this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getSCALE_MODIFIER(), (Object)Float.valueOf(trackedScaleModifier));
                    if (!Intrinsics.areEqual((float)this.getEntity().getPokemon().getRideStamina(), (Float)((Float)this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getRIDE_STAMINA()))) && this.getEntity().method_5685().isEmpty()) {
                        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getRIDE_STAMINA(), (Object)Float.valueOf(this.getEntity().getPokemon().getRideStamina()));
                    }
                    Map currentRideBoosts = (Map)this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getRIDE_BOOSTS());
                    newRideBoosts = this.getEntity().getPokemon().getRideBoosts();
                    if (currentRideBoosts.size() != newRideBoosts.size()) break block17;
                    Intrinsics.checkNotNull((Object)currentRideBoosts);
                    Map $this$any$iv = currentRideBoosts;
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator = $this$any$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry entry = element$iv = iterator.next();
                            boolean bl2 = false;
                            RidingStat key = (RidingStat)((Object)entry.getKey());
                            float value = ((Number)entry.getValue()).floatValue();
                            if (!(!Intrinsics.areEqual((Float)newRideBoosts.get((Object)key), (float)value))) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block18;
            }
            this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getRIDE_BOOSTS(), newRideBoosts);
        }
        this.updateShownItem();
        this.updatePoseType();
    }

    @Override
    public void onSyncedDataUpdated(@NotNull class_2940<?> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        PokemonSideDelegate.super.onSyncedDataUpdated(data);
        if (this.entity != null) {
            class_2940<?> class_29402 = data;
            if (Intrinsics.areEqual(class_29402, PokemonEntity.Companion.getBEHAVIOUR_FLAGS())) {
                this.updatePoseType();
            } else if (Intrinsics.areEqual(class_29402, PokemonEntity.Companion.getSPECIES())) {
                this.getEntity().refreshRiding();
            }
        }
    }

    @Override
    public void tick(@NotNull PokemonEntity entity) {
        PokemonPastureBlockEntity.Tethering tethering;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PokemonState state = entity.getPokemon().getState();
        if (!(state instanceof ActivePokemonState && Intrinsics.areEqual((Object)((ActivePokemonState)state).getEntity(), (Object)entity) || entity.method_29504() || !(entity.method_6032() > 0.0f))) {
            entity.getPokemon().setState(new SentOutState(entity));
        }
        if (entity.method_6139() != null && entity.getPokemon().getStoreCoordinates().get() == null) {
            entity.method_31472();
            return;
        }
        if (entity.getPokemon().isNPCOwned()) {
            class_1309 class_13092 = entity.method_35057();
            if (!(class_13092 != null ? class_13092.method_5805() : false) && entity.getBattleId() == null) {
                entity.method_31472();
                return;
            }
            if (entity.method_6139() == null) {
                entity.method_6174(entity.getPokemon().getOwnerUUID());
            }
        }
        if ((tethering = entity.getTethering()) != null && !Intrinsics.areEqual((Object)entity.getPokemon().getTetheringId(), (Object)tethering.getTetheringId())) {
            entity.method_31472();
            return;
        }
        class_2945 class_29452 = entity.method_5841();
        Intrinsics.checkNotNullExpressionValue((Object)class_29452, (String)"getEntityData(...)");
        class_2940<Optional<UUID>> class_29402 = PokemonEntity.Companion.getBATTLE_ID();
        Intrinsics.checkNotNullExpressionValue(class_29402, (String)"<get-BATTLE_ID>(...)");
        EntityExtensionsKt.update(class_29452, class_29402, PokemonServerDelegate::tick$lambda$0);
        PokemonBattle battle = this.getBattle();
        if (entity.getTicksLived() % 20 == 0 && battle != null) {
            ActiveBattlePokemon activeBattlePokemon;
            block14: {
                Iterable<ActiveBattlePokemon> iterable = battle.getActivePokemon();
                Iterator<ActiveBattlePokemon> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    ActiveBattlePokemon activeBattlePokemon2;
                    ActiveBattlePokemon it = activeBattlePokemon2 = iterator.next();
                    boolean bl = false;
                    BattlePokemon battlePokemon = it.getBattlePokemon();
                    if (!Intrinsics.areEqual((Object)(battlePokemon != null ? battlePokemon.getUuid() : null), (Object)entity.getPokemon().getUuid())) continue;
                    activeBattlePokemon = activeBattlePokemon2;
                    break block14;
                }
                activeBattlePokemon = null;
            }
            ActiveBattlePokemon activeBattlePokemon3 = activeBattlePokemon;
            if (activeBattlePokemon3 != null) {
                class_1937 class_19372 = entity.method_37908();
                Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                activeBattlePokemon3.setPosition((Pair<? extends class_3218, ? extends class_243>)TuplesKt.to((Object)((class_3218)class_19372), (Object)entity.method_19538()));
            }
        }
        this.updateHealth(entity.getPokemon());
        if (!Intrinsics.areEqual((Object)entity.method_6139(), (Object)entity.getPokemon().getOwnerUUID())) {
            entity.method_6174(entity.getPokemon().getOwnerUUID());
        }
        if (entity.method_6139() == null && tethering != null) {
            entity.method_6174(tethering.getPlayerId());
        }
        if (entity.method_6139() != null && entity.method_35057() == null && entity.getTethering() == null) {
            entity.method_5650(class_1297.class_5529.field_26999);
        }
        if (entity.method_37908().method_8510() % (long)20 == 0L) {
            for (SpeciesFeature feature : entity.getPokemon().getFeatures()) {
                if (!(feature instanceof TickingSpeciesFeature)) continue;
                TickingSpeciesFeature tickingSpeciesFeature = (TickingSpeciesFeature)((Object)feature);
                class_1937 class_19373 = entity.method_37908();
                Intrinsics.checkNotNull((Object)class_19373, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                tickingSpeciesFeature.onSecondPassed((class_3218)class_19373, entity.getPokemon(), entity);
            }
        }
        this.updateTrackedValues();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateShownItem() {
        void var2_4;
        Object object;
        block4: {
            block5: {
                Object object2;
                block3: {
                    if (this.getEntity().getPokemon().getHeldItemVisible()) break block3;
                    object = this.getEntity().method_6047();
                    break block4;
                }
                object = this.getEntity();
                if (object == null || (object = ((PokemonEntity)object).getPokemon()) == null || (object = ((Pokemon)object).heldItemNoCopy$common()) == null) break block5;
                Object it = object2 = object;
                boolean bl = false;
                object = !it.method_7960() ? object2 : null;
                if (object != null) break block4;
            }
            object = this.getEntity().method_6047();
        }
        class_1799 it = object.method_7972();
        boolean bl = false;
        class_1799 trackedShownItem = it.method_31573(CobblemonItemTags.HIDDEN_ITEMS) ? class_1799.field_8037 : var2_4;
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getSHOWN_HELD_ITEM(), (Object)trackedShownItem);
    }

    /*
     * Unable to fully structure code
     */
    public final void updatePoseType() {
        block8: {
            block9: {
                block7: {
                    block6: {
                        block5: {
                            if (!this.getEntity().getEnablePoseTypeRecalculation()) break block5;
                            v0 = this.getEntity().method_5685();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPassengers(...)");
                            if (!(((Collection)v0).isEmpty() == false)) break block6;
                        }
                        return;
                    }
                    if (this.getEntity().getBattle() == null) break block7;
                    v1 = this.getEntity().getPokemon().getStatus();
                    v2 = Intrinsics.areEqual((Object)(v1 != null ? v1.getStatus() : null), (Object)Statuses.SLEEP);
                    break block8;
                }
                if (BrainExtensionsKt.getMemorySafely(this.getEntity().method_18868(), CobblemonMemories.POKEMON_SLEEPING).orElse(false).booleanValue()) break block9;
                v3 = this.getEntity().getPokemon().getStatus();
                if (!Intrinsics.areEqual((Object)(v3 != null ? v3.getStatus() : null), (Object)Statuses.SLEEP)) ** GOTO lbl-1000
            }
            if (this.getEntity().getBehaviour().getResting().getCanSleep()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
        }
        isSleeping = v2;
        isMoving = (Boolean)this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getMOVING());
        isPassenger = this.getEntity().method_5765();
        isUnderwater = EntityExtensionsKt.getIsSubmerged((class_1297)this.getEntity());
        isFlying = this.getEntity().getBehaviourFlag(PokemonBehaviourFlag.FLYING);
        poseType = isPassenger != false ? PoseType.STAND : (isSleeping != false ? PoseType.SLEEP : (isMoving != false && isUnderwater != false ? PoseType.SWIM : (isUnderwater != false ? PoseType.FLOAT : (isMoving != false && isFlying != false ? PoseType.FLY : (isFlying != false ? PoseType.HOVER : (isMoving != false ? PoseType.WALK : PoseType.STAND))))));
        this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getPOSE_TYPE(), (Object)poseType);
    }

    @Override
    public void drop(@Nullable class_1282 source) {
        class_3222 player;
        class_1282 class_12822 = source;
        class_1297 class_12972 = class_12822 != null ? class_12822.method_5526() : null;
        class_3222 class_32222 = player = class_12972 instanceof class_3222 ? (class_3222)class_12972 : null;
        if (this.getEntity().getPokemon().isWild()) {
            this.getEntity().setKiller(player);
        }
    }

    public final void doDeathDrops() {
        if (this.getEntity().method_6139() == null && this.getEntity().method_35057() == null && this.getEntity().method_37908().method_8450().method_8355(CobblemonGameRules.DO_POKEMON_LOOT)) {
            DropTable dropTable;
            Object heldItem;
            Object object = this.getEntity();
            if (object == null || (object = ((PokemonEntity)object).getPokemon()) == null || (object = ((Pokemon)object).heldItemNoCopy$common()) == null) {
                object = class_1799.field_8037;
            }
            if (!(heldItem = object).method_7960()) {
                this.getEntity().method_5706((class_1935)heldItem.method_7909());
            }
            if ((dropTable = this.getEntity().getDrops()) == null) {
                dropTable = this.getEntity().getPokemon().getForm().getDrops();
            }
            DropTable dropTable2 = dropTable;
            List drops = CollectionsKt.toMutableList((Collection)DropTable.getDrops$default(dropTable2, null, null, 3, null));
            if (this.getEntity().getPokemon().getForcedAspects().contains("drops_reroll")) {
                List dropsReroll = DropTable.getDrops$default(dropTable2, null, null, 3, null);
                drops.addAll(dropsReroll);
            }
            class_1309 class_13092 = (class_1309)this.getEntity();
            class_1937 class_19372 = this.getEntity().method_37908();
            Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            class_3218 class_32182 = (class_3218)class_19372;
            class_243 class_2432 = this.getEntity().method_19538();
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"position(...)");
            dropTable2.postLootDroppedEvent(drops, class_13092, class_32182, class_2432, this.getEntity().getKiller());
        }
    }

    @Override
    public void updatePostDeath() {
        class_1309 owner = this.getEntity().method_35057();
        if (!((Boolean)this.getEntity().method_5841().method_12789(PokemonEntity.Companion.getDYING_EFFECTS_STARTED())).booleanValue()) {
            this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getDYING_EFFECTS_STARTED(), (Object)true);
            if (owner instanceof PokemonSender && this.getEntity().getBeamMode() == -1) {
                this.getEntity().recallWithAnimation();
            }
        }
        if (this.getEntity().field_6213 == 0) {
            this.getEntity().getEffects().wipe();
            this.getEntity().field_6213 = 1;
            if (!Cobblemon.INSTANCE.getConfig().getDropAfterDeathAnimation()) {
                this.doDeathDrops();
            }
            return;
        }
        CompletableFuture<PokemonEntity> completableFuture = this.getEntity().getEffects().getProgress();
        boolean bl = completableFuture != null ? !completableFuture.isDone() : false;
        if (bl) {
            return;
        }
        PokemonEntity pokemonEntity = this.getEntity();
        ++pokemonEntity.field_6213;
        int cfr_ignored_0 = pokemonEntity.field_6213;
        if (this.getEntity().field_6213 == 30 && owner != null && !(owner instanceof PokemonSender)) {
            class_1937 class_19372 = this.getEntity().method_37908();
            Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"level(...)");
            class_243 class_2432 = owner.method_19538();
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"position(...)");
            WorldExtensionsKt.playSoundServer$default(class_19372, class_2432, CobblemonSounds.POKE_BALL_RECALL, null, 0.6f, 0.0f, 20, null);
            this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getPHASING_TARGET_ID(), (Object)owner.method_5628());
            this.getEntity().method_5841().method_12778(PokemonEntity.Companion.getBEAM_MODE(), (Object)3);
        }
        if (this.getEntity().field_6213 == 60) {
            this.getEntity().method_37908().method_8421((class_1297)this.getEntity(), (byte)60);
            if (Cobblemon.INSTANCE.getConfig().getDropAfterDeathAnimation()) {
                this.doDeathDrops();
            }
            this.getEntity().method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Override
    public void positionRider(@NotNull class_1297 passenger, @NotNull class_1297.class_4738 positionUpdater) {
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        Intrinsics.checkNotNullParameter((Object)positionUpdater, (String)"positionUpdater");
        Integer n = this.getEntity().method_5685().indexOf(passenger);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 && it < this.getEntity().getSeats().size() ? n : null;
        if (n2 == null) {
            return;
        }
        int index = n2;
        Seat seat = this.getEntity().getSeats().get(index);
        Vector3f seatOffset = seat.getOffset(this.getEntity().getCurrentPoseType()).method_46409();
        Vector3f center = new Vector3f(0.0f, this.getEntity().method_17682() / (float)2, 0.0f);
        Vector3f seatToCenter = center.sub((Vector3fc)seatOffset, new Vector3f());
        List list = this.getEntity().method_5685();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
        Object object = CollectionsKt.first((List)list);
        Object object2 = object instanceof OrientationControllable ? (OrientationControllable)object : null;
        if (object2 == null || (object2 = object2.getOrientationController()) == null || (object2 = ((OrientationController)object2).getOrientation()) == null) {
            object2 = new Matrix3f().rotate(AngleExtensionsKt.toRadians(Float.valueOf(180.0f - passenger.method_36454())), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        }
        Object matrix = object2;
        Vector3f offset = matrix.transform((Vector3fc)seatToCenter, new Vector3f()).add((Vector3fc)center).sub((Vector3fc)new Vector3f(0.0f, passenger.method_17682() / (float)2, 0.0f));
        positionUpdater.accept(passenger, this.getEntity().method_23317() + (double)offset.x, this.getEntity().method_23318() + (double)offset.y, this.getEntity().method_23321() + (double)offset.z);
    }

    private static final Object addToStruct$lambda$0(PokemonServerDelegate this$0, MoParams params) {
        class_3222 class_32222;
        Object opponentValue = params.get(0);
        if (opponentValue instanceof ObjectValue) {
            Object t = ((ObjectValue)opponentValue).getObj();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            class_32222 = (class_3222)t;
        } else {
            String paramString = opponentValue.asString();
            Intrinsics.checkNotNull((Object)paramString);
            UUID playerUUID = MiscUtilsKt.getAsUUID(paramString);
            if (playerUUID != null) {
                MinecraftServer minecraftServer = this$0.getEntity().method_5682();
                Intrinsics.checkNotNull((Object)minecraftServer);
                class_32222 = minecraftServer.method_3760().method_14602(playerUUID);
                if (class_32222 == null) {
                    return DoubleValue.ZERO;
                }
            } else {
                MinecraftServer minecraftServer = this$0.getEntity().method_5682();
                Intrinsics.checkNotNull((Object)minecraftServer);
                class_32222 = minecraftServer.method_3760().method_14566(paramString);
                if (class_32222 == null) {
                    return DoubleValue.ZERO;
                }
            }
        }
        class_3222 opponent = class_32222;
        return this$0.getEntity().after(0.01f, (Function0<Unit>)((Function0)() -> PokemonServerDelegate.addToStruct$lambda$0$0(this$0, opponent)));
    }

    private static final Unit addToStruct$lambda$0$0(PokemonServerDelegate this$0, class_3222 $opponent) {
        new DoubleValue(this$0.getEntity().forceBattle($opponent));
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Optional tick$lambda$0(Optional opt) {
        Optional<Object> optional;
        UUID battleId = opt.orElse(null);
        if (battleId != null) {
            PokemonBattle it = BattleRegistry.getBattle(battleId);
            boolean bl = false;
            boolean bl2 = it == null || it.getEnded();
            if (bl2) {
                optional = Optional.empty();
                return optional;
            }
        }
        optional = opt;
        return optional;
    }
}

