/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.player.factory;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataFactory;
import com.cobblemon.mod.common.api.storage.player.adapter.PlayerDataStoreBackend;
import com.cobblemon.mod.common.net.messages.client.SetClientPlayerDataPacket;
import com.cobblemon.mod.common.util.MapExtensionsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0018R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/api/storage/player/factory/CachedPlayerDataStoreFactory;", "Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "T", "Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataFactory;", "Lcom/cobblemon/mod/common/api/storage/player/adapter/PlayerDataStoreBackend;", "backend", "<init>", "(Lcom/cobblemon/mod/common/api/storage/player/adapter/PlayerDataStoreBackend;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "setup", "(Lnet/minecraft/server/MinecraftServer;)V", "Ljava/util/UUID;", "playerId", "getForPlayer", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "saveAll", "()V", "saveSingle", "(Ljava/util/UUID;)V", "Lnet/minecraft/class_3222;", "player", "onPlayerDisconnect", "(Lnet/minecraft/class_3222;)V", "sendToPlayer", "Lcom/cobblemon/mod/common/api/storage/player/adapter/PlayerDataStoreBackend;", "getBackend", "()Lcom/cobblemon/mod/common/api/storage/player/adapter/PlayerDataStoreBackend;", "", "cache", "Ljava/util/Map;", "common"})
@SourceDebugExtension(value={"SMAP\nCachedPlayerDataStoreFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedPlayerDataStoreFactory.kt\ncom/cobblemon/mod/common/api/storage/player/factory/CachedPlayerDataStoreFactory\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,63:1\n216#2,2:64\n*S KotlinDebug\n*F\n+ 1 CachedPlayerDataStoreFactory.kt\ncom/cobblemon/mod/common/api/storage/player/factory/CachedPlayerDataStoreFactory\n*L\n46#1:64,2\n*E\n"})
public final class CachedPlayerDataStoreFactory<T extends InstancedPlayerData>
implements PlayerInstancedDataFactory<T> {
    @NotNull
    private final PlayerDataStoreBackend<T> backend;
    @NotNull
    private final Map<UUID, T> cache;

    public CachedPlayerDataStoreFactory(@NotNull PlayerDataStoreBackend<T> backend) {
        Intrinsics.checkNotNullParameter(backend, (String)"backend");
        this.backend = backend;
        this.cache = new LinkedHashMap();
    }

    @NotNull
    public final PlayerDataStoreBackend<T> getBackend() {
        return this.backend;
    }

    @Override
    public void setup(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.backend.setup(server);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public T getForPlayer(@NotNull UUID playerId) {
        InstancedPlayerData instancedPlayerData;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        if (this.cache.containsKey(playerId)) {
            T t = this.cache.get(playerId);
            Intrinsics.checkNotNull(t);
            instancedPlayerData = (InstancedPlayerData)t;
        } else {
            void var2_2;
            T data = this.backend.load(playerId);
            this.cache.put(playerId, data);
            instancedPlayerData = var2_2;
        }
        return (T)instancedPlayerData;
    }

    @Override
    public void saveAll() {
        Map<UUID, T> $this$forEach$iv = this.cache;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, T>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, T> element$iv;
            Map.Entry<UUID, T> entry = element$iv = iterator.next();
            boolean bl = false;
            InstancedPlayerData pd = (InstancedPlayerData)entry.getValue();
            this.backend.save(pd);
        }
        MapExtensionsKt.removeIf(this.cache, CachedPlayerDataStoreFactory::saveAll$lambda$1);
    }

    @Override
    public void saveSingle(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        this.backend.save(this.getForPlayer(playerId));
    }

    @Override
    public void onPlayerDisconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.saveSingle(uUID);
        this.cache.remove(player.method_5667());
    }

    @Override
    public void sendToPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CobblemonNetwork.INSTANCE.sendPacket(player, new SetClientPlayerDataPacket(this.backend.getDataType(), this.getForPlayer((class_1657)player).toClientData(), false, 4, null));
    }

    private static final boolean saveAll$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        UUID uuid = (UUID)entry.getKey();
        return PlayerExtensionsKt.getPlayer(uuid) == null;
    }
}

