/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.position.calculators;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawningZone;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.SubmergedSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.calculators.AreaSpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.position.calculators.AreaSpawningInput;
import com.cobblemon.mod.common.api.spawning.position.calculators.SpawnablePositionCalculator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u00108\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R)\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n0\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/api/spawning/position/calculators/SubmergedSpawnablePositionCalculator;", "Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawnablePositionCalculator;", "Lcom/cobblemon/mod/common/api/spawning/position/SubmergedSpawnablePosition;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawningInput;", "input", "", "fits", "(Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawningInput;)Z", "Lkotlin/Function1;", "Lnet/minecraft/class_2680;", "getFluidCondition", "(Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawningInput;)Lkotlin/jvm/functions/Function1;", "calculate", "(Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawningInput;)Lcom/cobblemon/mod/common/api/spawning/position/SubmergedSpawnablePosition;", "", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "", "fluidConditions", "Ljava/util/List;", "getFluidConditions", "()Ljava/util/List;", "common"})
@SourceDebugExtension(value={"SMAP\nSubmergedSpawnablePositionCalculators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubmergedSpawnablePositionCalculators.kt\ncom/cobblemon/mod/common/api/spawning/position/calculators/SubmergedSpawnablePositionCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n295#2,2:61\n*S KotlinDebug\n*F\n+ 1 SubmergedSpawnablePositionCalculators.kt\ncom/cobblemon/mod/common/api/spawning/position/calculators/SubmergedSpawnablePositionCalculator\n*L\n39#1:61,2\n*E\n"})
public final class SubmergedSpawnablePositionCalculator
implements AreaSpawnablePositionCalculator<SubmergedSpawnablePosition> {
    @NotNull
    public static final SubmergedSpawnablePositionCalculator INSTANCE = new SubmergedSpawnablePositionCalculator();
    @NotNull
    private static final String name = "submerged";
    @NotNull
    private static final List<Function1<class_2680, Boolean>> fluidConditions;

    private SubmergedSpawnablePositionCalculator() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @NotNull
    public final List<Function1<class_2680, Boolean>> getFluidConditions() {
        return fluidConditions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean fits(@NotNull AreaSpawningInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Function1<class_2680, Boolean> condition = this.getFluidCondition(input);
        if (condition == null) return false;
        SpawningZone spawningZone = input.getZone();
        class_2338 class_23382 = input.getPosition().method_10074();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"below(...)");
        if ((Boolean)condition.invoke((Object)SpawningZone.getBlockState$default(spawningZone, class_23382, null, 2, null)) == false) return false;
        SpawningZone spawningZone2 = input.getZone();
        class_2338 class_23383 = input.getPosition().method_10084();
        Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"above(...)");
        if ((Boolean)condition.invoke((Object)SpawningZone.getBlockState$default(spawningZone2, class_23383, null, 2, null)) == false) return false;
        return true;
    }

    @Nullable
    public final Function1<class_2680, Boolean> getFluidCondition(@NotNull AreaSpawningInput input) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Iterable $this$firstOrNull$iv = fluidConditions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                if (!((Boolean)it.invoke((Object)SpawningZone.getBlockState$default(input.getZone(), input.getPosition(), null, 2, null))).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public SubmergedSpawnablePosition calculate(@NotNull AreaSpawningInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Function1<class_2680, Boolean> function1 = this.getFluidCondition(input);
        Intrinsics.checkNotNull(function1);
        Function1<class_2680, Boolean> fluidCondition = function1;
        SpawnCause spawnCause = input.getCause();
        class_3218 class_32182 = input.getWorld();
        class_2338 class_23382 = input.getPosition().method_10062();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"immutable(...)");
        class_2338 class_23383 = class_23382;
        int n = AreaSpawnablePositionCalculator.getLight$default(this, input, 0, 2, null);
        int n2 = AreaSpawnablePositionCalculator.getSkyLight$default(this, input, 0, 2, null);
        boolean bl = this.getCanSeeSky(input);
        List<SpawningInfluence> list = input.getSpawner().copyInfluences();
        int n3 = AreaSpawnablePositionCalculator.getHeight$default(this, input, fluidCondition, class_3532.method_15386((float)((float)Cobblemon.INSTANCE.getConfig().getMaxVerticalSpace() / 2.0f)), 0, 0, 0, 56, null);
        int n4 = this.getDepth(input, fluidCondition, class_3532.method_15386((float)((float)Cobblemon.INSTANCE.getConfig().getMaxVerticalSpace() / 2.0f)));
        SpawningZone spawningZone = input.getZone();
        List list2 = AreaSpawnablePositionCalculator.getNearbyBlocks$default(this, input, 0, 0, 6, null);
        return new SubmergedSpawnablePosition(spawnCause, class_32182, class_23383, n, n2, bl, list, n3, n4, list2, spawningZone);
    }

    static {
        Object[] objectArray = new Function1[]{SpawnablePositionCalculator.Companion.isWaterCondition(), SpawnablePositionCalculator.Companion.isLavaCondition()};
        fluidConditions = CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

