/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.entity.Despawner;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.SpawnDetailPresets;
import com.cobblemon.mod.common.api.spawning.condition.AreaSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.BasicSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.FishingSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.GroundedSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SeafloorSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SubmergedSpawningCondition;
import com.cobblemon.mod.common.api.spawning.condition.SurfaceSpawningCondition;
import com.cobblemon.mod.common.api.spawning.detail.NPCSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.PokemonHerdSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.influence.BucketMultiplyingInfluence;
import com.cobblemon.mod.common.api.spawning.position.FishingSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.GroundedSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.LavafloorSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SeafloorSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SubmergedSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SurfaceSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.calculators.GroundedSpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.position.calculators.LavafloorSpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.position.calculators.SeafloorSpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.position.calculators.SpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.position.calculators.SubmergedSpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.position.calculators.SurfaceSpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.preset.BasicSpawnDetailPreset;
import com.cobblemon.mod.common.api.spawning.preset.BestSpawnerConfig;
import com.cobblemon.mod.common.api.spawning.preset.PokemonSpawnDetailPreset;
import com.cobblemon.mod.common.api.spawning.spawner.BasicSpawner;
import com.cobblemon.mod.common.entity.pokemon.CobblemonAgingDespawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/api/spawning/BestSpawner;", "", "<init>", "()V", "", "init", "loadConfig", "reloadConfig", "Lnet/minecraft/server/MinecraftServer;", "server", "onServerStarted", "(Lnet/minecraft/server/MinecraftServer;)V", "Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "config", "Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "getConfig", "()Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;", "setConfig", "(Lcom/cobblemon/mod/common/api/spawning/preset/BestSpawnerConfig;)V", "Lcom/cobblemon/mod/common/api/entity/Despawner;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "defaultPokemonDespawner", "Lcom/cobblemon/mod/common/api/entity/Despawner;", "getDefaultPokemonDespawner", "()Lcom/cobblemon/mod/common/api/entity/Despawner;", "setDefaultPokemonDespawner", "(Lcom/cobblemon/mod/common/api/entity/Despawner;)V", "Lcom/cobblemon/mod/common/api/spawning/spawner/BasicSpawner;", "fishingSpawner", "Lcom/cobblemon/mod/common/api/spawning/spawner/BasicSpawner;", "getFishingSpawner", "()Lcom/cobblemon/mod/common/api/spawning/spawner/BasicSpawner;", "setFishingSpawner", "(Lcom/cobblemon/mod/common/api/spawning/spawner/BasicSpawner;)V", "common"})
public final class BestSpawner {
    @NotNull
    public static final BestSpawner INSTANCE = new BestSpawner();
    @NotNull
    private static BestSpawnerConfig config = new BestSpawnerConfig();
    public static Despawner<PokemonEntity> defaultPokemonDespawner;
    public static BasicSpawner fishingSpawner;

    private BestSpawner() {
    }

    @NotNull
    public final BestSpawnerConfig getConfig() {
        return config;
    }

    public final void setConfig(@NotNull BestSpawnerConfig bestSpawnerConfig) {
        Intrinsics.checkNotNullParameter((Object)bestSpawnerConfig, (String)"<set-?>");
        config = bestSpawnerConfig;
    }

    @NotNull
    public final Despawner<PokemonEntity> getDefaultPokemonDespawner() {
        Despawner<PokemonEntity> despawner = defaultPokemonDespawner;
        if (despawner != null) {
            return despawner;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"defaultPokemonDespawner");
        return null;
    }

    public final void setDefaultPokemonDespawner(@NotNull Despawner<PokemonEntity> despawner) {
        Intrinsics.checkNotNullParameter(despawner, (String)"<set-?>");
        defaultPokemonDespawner = despawner;
    }

    @NotNull
    public final BasicSpawner getFishingSpawner() {
        BasicSpawner basicSpawner = fishingSpawner;
        if (basicSpawner != null) {
            return basicSpawner;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fishingSpawner");
        return null;
    }

    public final void setFishingSpawner(@NotNull BasicSpawner basicSpawner) {
        Intrinsics.checkNotNullParameter((Object)basicSpawner, (String)"<set-?>");
        fishingSpawner = basicSpawner;
    }

    public final void init() {
        Cobblemon.LOGGER.info("Starting the Best Spawner...");
        SpawningCondition.Companion.register("basic", BasicSpawningCondition.class);
        SpawningCondition.Companion.register("area", AreaSpawningCondition.class);
        SpawningCondition.Companion.register("submerged", SubmergedSpawningCondition.class);
        SpawningCondition.Companion.register("grounded", GroundedSpawningCondition.class);
        SpawningCondition.Companion.register("surface", SurfaceSpawningCondition.class);
        SpawningCondition.Companion.register("seafloor", SeafloorSpawningCondition.class);
        SpawningCondition.Companion.register("fishing", FishingSpawningCondition.class);
        Cobblemon.LOGGER.info("Loaded " + SpawningCondition.Companion.getConditionTypes().size() + " spawning condition types.");
        SpawnablePositionCalculator.Companion.register$default(SpawnablePositionCalculator.Companion, GroundedSpawnablePositionCalculator.INSTANCE, null, 2, null);
        SpawnablePositionCalculator.Companion.register$default(SpawnablePositionCalculator.Companion, SeafloorSpawnablePositionCalculator.INSTANCE, null, 2, null);
        SpawnablePositionCalculator.Companion.register$default(SpawnablePositionCalculator.Companion, LavafloorSpawnablePositionCalculator.INSTANCE, null, 2, null);
        SpawnablePositionCalculator.Companion.register$default(SpawnablePositionCalculator.Companion, SubmergedSpawnablePositionCalculator.INSTANCE, null, 2, null);
        SpawnablePositionCalculator.Companion.register$default(SpawnablePositionCalculator.Companion, SurfaceSpawnablePositionCalculator.INSTANCE, null, 2, null);
        SpawnablePosition.Companion.register("grounded", GroundedSpawnablePosition.class, "grounded");
        SpawnablePosition.Companion.register("seafloor", SeafloorSpawnablePosition.class, "seafloor");
        SpawnablePosition.Companion.register("lavafloor", LavafloorSpawnablePosition.class, "grounded");
        SpawnablePosition.Companion.register("submerged", SubmergedSpawnablePosition.class, "submerged");
        SpawnablePosition.Companion.register("surface", SurfaceSpawnablePosition.class, "surface");
        SpawnablePosition.Companion.register("fishing", FishingSpawnablePosition.class, "fishing");
        Cobblemon.LOGGER.info("Loaded " + SpawnablePosition.Companion.getSpawnablePositionTypes().size() + " spawnable position types.");
        SpawnDetail.Companion.registerSpawnType(PokemonSpawnDetail.Companion.getTYPE(), PokemonSpawnDetail.class);
        SpawnDetail.Companion.registerSpawnType(NPCSpawnDetail.Companion.getTYPE(), NPCSpawnDetail.class);
        SpawnDetail.Companion.registerSpawnType(PokemonHerdSpawnDetail.Companion.getTYPE(), PokemonHerdSpawnDetail.class);
        Cobblemon.LOGGER.info("Loaded " + SpawnDetail.Companion.getSpawnDetailTypes().size() + " spawn detail types.");
        this.loadConfig();
        SpawnDetailPresets.INSTANCE.registerPresetType("basic", BasicSpawnDetailPreset.class);
        SpawnDetailPresets.INSTANCE.registerPresetType("pokemon", PokemonSpawnDetailPreset.class);
    }

    public final void loadConfig() {
        this.setDefaultPokemonDespawner(new CobblemonAgingDespawner(BestSpawner::loadConfig$lambda$0));
        config = BestSpawnerConfig.Companion.load();
    }

    public final void reloadConfig() {
        this.loadConfig();
    }

    /*
     * WARNING - void declaration
     */
    public final void onServerStarted(@NotNull MinecraftServer server) {
        void it;
        BasicSpawner basicSpawner;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CobblemonSpawnPools.INSTANCE.onServerLoad(server);
        BasicSpawner basicSpawner2 = basicSpawner = new BasicSpawner("fishing", CobblemonSpawnPools.INSTANCE.getWORLD_SPAWN_POOL(), 0.0f, 4, null);
        BestSpawner bestSpawner = this;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"uncommon", (Object)Float.valueOf(2.25f)), TuplesKt.to((Object)"rare", (Object)Float.valueOf(5.5f)), TuplesKt.to((Object)"ultra-rare", (Object)Float.valueOf(5.5f))};
        it.getInfluences().add(new BucketMultiplyingInfluence(MapsKt.mapOf((Pair[])pairArray)));
        bestSpawner.setFishingSpawner(basicSpawner);
    }

    private static final int loadConfig$lambda$0(PokemonEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTicksLived();
    }
}

