/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.composite;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourStateKt;
import com.cobblemon.mod.common.api.riding.behaviour.Side;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0004\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001c\u0010\u001bR(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R(\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u001f\u001a\u0004\b&\u0010!\"\u0004\b'\u0010#R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010!R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020+0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010!\u00a8\u0006."}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeState;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "Lnet/minecraft/class_2960;", "defaultBehaviour", "defaultBehaviourState", "alternateBehaviourState", "<init>", "(Lnet/minecraft/class_2960;Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;)V", "", "reset", "()V", "copy", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeState;", "previous", "", "shouldSync", "(Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;)Z", "Lnet/minecraft/class_2540;", "buffer", "encode", "(Lnet/minecraft/class_2540;)V", "decode", "Lnet/minecraft/class_2960;", "getDefaultBehaviour", "()Lnet/minecraft/class_2960;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "getDefaultBehaviourState", "()Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "getAlternateBehaviourState", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "activeBehaviour", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "getActiveBehaviour", "()Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "setActiveBehaviour", "(Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;)V", "", "lastTransition", "getLastTransition", "setLastTransition", "Lnet/minecraft/class_243;", "getRideVelocity", "rideVelocity", "", "getStamina", "stamina", "common"})
public final class CompositeState
extends RidingBehaviourState {
    @NotNull
    private final class_2960 defaultBehaviour;
    @NotNull
    private final RidingBehaviourState defaultBehaviourState;
    @NotNull
    private final RidingBehaviourState alternateBehaviourState;
    @NotNull
    private SidedRidingState<class_2960> activeBehaviour;
    @NotNull
    private SidedRidingState<Long> lastTransition;

    public CompositeState(@NotNull class_2960 defaultBehaviour, @NotNull RidingBehaviourState defaultBehaviourState, @NotNull RidingBehaviourState alternateBehaviourState) {
        Intrinsics.checkNotNullParameter((Object)defaultBehaviour, (String)"defaultBehaviour");
        Intrinsics.checkNotNullParameter((Object)defaultBehaviourState, (String)"defaultBehaviourState");
        Intrinsics.checkNotNullParameter((Object)alternateBehaviourState, (String)"alternateBehaviourState");
        this.defaultBehaviour = defaultBehaviour;
        this.defaultBehaviourState = defaultBehaviourState;
        this.alternateBehaviourState = alternateBehaviourState;
        this.activeBehaviour = RidingBehaviourStateKt.ridingState(this.defaultBehaviour, Side.CLIENT);
        this.lastTransition = RidingBehaviourStateKt.ridingState(-100L, Side.BOTH);
    }

    @NotNull
    public final class_2960 getDefaultBehaviour() {
        return this.defaultBehaviour;
    }

    @NotNull
    public final RidingBehaviourState getDefaultBehaviourState() {
        return this.defaultBehaviourState;
    }

    @NotNull
    public final RidingBehaviourState getAlternateBehaviourState() {
        return this.alternateBehaviourState;
    }

    @NotNull
    public final SidedRidingState<class_2960> getActiveBehaviour() {
        return this.activeBehaviour;
    }

    public final void setActiveBehaviour(@NotNull SidedRidingState<class_2960> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.activeBehaviour = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Long> getLastTransition() {
        return this.lastTransition;
    }

    public final void setLastTransition(@NotNull SidedRidingState<Long> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.lastTransition = sidedRidingState;
    }

    @Override
    @NotNull
    public SidedRidingState<class_243> getRideVelocity() {
        return Intrinsics.areEqual((Object)this.activeBehaviour.get(), (Object)this.defaultBehaviour) ? this.defaultBehaviourState.getRideVelocity() : this.alternateBehaviourState.getRideVelocity();
    }

    @Override
    @NotNull
    public SidedRidingState<Float> getStamina() {
        return Intrinsics.areEqual((Object)this.activeBehaviour.get(), (Object)this.defaultBehaviour) ? this.defaultBehaviourState.getStamina() : this.alternateBehaviourState.getStamina();
    }

    @Override
    public void reset() {
        super.reset();
        this.activeBehaviour.set(this.defaultBehaviour, true);
        this.lastTransition.set(-100L, true);
        this.defaultBehaviourState.reset();
        this.alternateBehaviourState.reset();
    }

    @Override
    @NotNull
    public CompositeState copy() {
        CompositeState state = new CompositeState(this.defaultBehaviour, this.defaultBehaviourState.copy(), this.alternateBehaviourState.copy());
        state.activeBehaviour.set(this.activeBehaviour.get(), true);
        state.lastTransition.set(this.lastTransition.get(), true);
        state.getRideVelocity().set(this.getRideVelocity().get(), true);
        state.getStamina().set(this.getStamina().get(), true);
        return state;
    }

    @Override
    public boolean shouldSync(@NotNull RidingBehaviourState previous) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        if (!(previous instanceof CompositeState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((CompositeState)previous).activeBehaviour.get(), (Object)this.activeBehaviour.get())) {
            return true;
        }
        if (this.defaultBehaviourState.shouldSync(((CompositeState)previous).defaultBehaviourState)) {
            return true;
        }
        if (this.alternateBehaviourState.shouldSync(((CompositeState)previous).alternateBehaviourState)) {
            return true;
        }
        return super.shouldSync(previous);
    }

    @Override
    public void encode(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.encode(buffer);
        buffer.method_10812(this.activeBehaviour.get());
        this.defaultBehaviourState.encode(buffer);
        this.alternateBehaviourState.encode(buffer);
    }

    @Override
    public void decode(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.decode(buffer);
        class_2960 class_29602 = buffer.method_10810();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"readResourceLocation(...)");
        this.activeBehaviour.set(class_29602, true);
        this.defaultBehaviourState.decode(buffer);
        this.alternateBehaviourState.decode(buffer);
    }
}

