/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.BirdBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.GliderBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.HelicopterBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.HoverBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.JetBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.RocketBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.CompositeBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.land.HorseBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.land.MinekartBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.land.VehicleBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.BoatBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.BurstBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.DolphinBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.SubmarineBehaviour;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0016\u0010\t\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00020\b0\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR/\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviours;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "key", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "behaviour", "", "register", "(Lnet/minecraft/class_2960;Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;)V", "get", "(Lnet/minecraft/class_2960;)Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "", "behaviours", "Ljava/util/Map;", "getBehaviours", "()Ljava/util/Map;", "common"})
public final class RidingBehaviours {
    @NotNull
    public static final RidingBehaviours INSTANCE = new RidingBehaviours();
    @NotNull
    private static final Map<class_2960, RidingBehaviour<RidingBehaviourSettings, RidingBehaviourState>> behaviours = new LinkedHashMap();

    private RidingBehaviours() {
    }

    @NotNull
    public final Map<class_2960, RidingBehaviour<RidingBehaviourSettings, RidingBehaviourState>> getBehaviours() {
        return behaviours;
    }

    @JvmStatic
    public static final void register(@NotNull class_2960 key, @NotNull RidingBehaviour<? extends RidingBehaviourSettings, ? extends RidingBehaviourState> behaviour) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(behaviour, (String)"behaviour");
        if (behaviours.containsKey(key)) {
            throw new IllegalStateException(("Behaviour already registered to key " + key).toString());
        }
        behaviours.put(key, behaviour);
    }

    @JvmStatic
    @NotNull
    public static final RidingBehaviour<RidingBehaviourSettings, RidingBehaviourState> get(@NotNull class_2960 key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!behaviours.containsKey(key)) {
            throw new IllegalStateException(("Behaviour not registered to key " + key).toString());
        }
        RidingBehaviour<RidingBehaviourSettings, RidingBehaviourState> ridingBehaviour = behaviours.get(key);
        Intrinsics.checkNotNull(ridingBehaviour);
        return ridingBehaviour;
    }

    static {
        RidingBehaviours.register(BirdBehaviour.Companion.getKEY(), new BirdBehaviour());
        RidingBehaviours.register(DolphinBehaviour.Companion.getKEY(), new DolphinBehaviour());
        RidingBehaviours.register(HorseBehaviour.Companion.getKEY(), new HorseBehaviour());
        RidingBehaviours.register(BoatBehaviour.Companion.getKEY(), new BoatBehaviour());
        RidingBehaviours.register(GliderBehaviour.Companion.getKEY(), new GliderBehaviour());
        RidingBehaviours.register(HelicopterBehaviour.Companion.getKEY(), new HelicopterBehaviour());
        RidingBehaviours.register(JetBehaviour.Companion.getKEY(), new JetBehaviour());
        RidingBehaviours.register(BurstBehaviour.Companion.getKEY(), new BurstBehaviour());
        RidingBehaviours.register(VehicleBehaviour.Companion.getKEY(), new VehicleBehaviour());
        RidingBehaviours.register(MinekartBehaviour.Companion.getKEY(), new MinekartBehaviour());
        RidingBehaviours.register(HoverBehaviour.Companion.getKEY(), new HoverBehaviour());
        RidingBehaviours.register(RocketBehaviour.Companion.getKEY(), new RocketBehaviour());
        RidingBehaviours.register(SubmarineBehaviour.Companion.getKEY(), new SubmarineBehaviour());
        RidingBehaviours.register(CompositeBehaviour.Companion.getKEY(), new CompositeBehaviour());
    }
}

