/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.orientation;

import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\r\u001a\u00020\f2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0004\b\u001b\u0010\u0010J\u0015\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001f\u0010\u001dJ\u0015\u0010!\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0011\u00a2\u0006\u0004\b!\u0010\u001dJ\u0015\u0010#\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0011\u00a2\u0006\u0004\b#\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&R\"\u0010'\u001a\u00020\u00068\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010\b\"\u0004\b*\u0010+R(\u0010-\u001a\u0004\u0018\u00010\n2\b\u0010,\u001a\u0004\u0018\u00010\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0018\u00101\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010.R\u0018\u00102\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010.R\u0011\u00106\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00108\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b7\u00105R\u0011\u0010:\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b9\u00105R\u0011\u0010\u0012\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0011\u0010\u0013\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b=\u0010<R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b>\u0010<\u00a8\u0006@"}, d2={"Lcom/cobblemon/mod/common/api/orientation/OrientationController;", "", "Lnet/minecraft/class_1309;", "entity", "<init>", "(Lnet/minecraft/class_1309;)V", "", "isActive", "()Z", "Lkotlin/Function1;", "Lorg/joml/Matrix3f;", "fn", "", "updateOrientation", "(Lkotlin/jvm/functions/Function1;)V", "reset", "()V", "", "yaw", "pitch", "roll", "rotate", "(FFF)V", "delta", "Lorg/joml/Quaternionf;", "getRenderOrientation", "(F)Lorg/joml/Quaternionf;", "tick", "rotateYaw", "(F)V", "rotatePitch", "rotateRoll", "deltaYawDegrees", "applyGlobalYaw", "deltaPitchDegrees", "applyGlobalPitch", "Lnet/minecraft/class_1309;", "getEntity", "()Lnet/minecraft/class_1309;", "active", "Z", "getActive", "setActive", "(Z)V", "value", "orientation", "Lorg/joml/Matrix3f;", "getOrientation", "()Lorg/joml/Matrix3f;", "renderOrientationO", "renderOrientation", "Lorg/joml/Vector3f;", "getForwardVector", "()Lorg/joml/Vector3f;", "forwardVector", "getLeftVector", "leftVector", "getUpVector", "upVector", "getYaw", "()F", "getPitch", "getRoll", "Companion", "common"})
public class OrientationController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_1309 entity;
    private boolean active;
    @Nullable
    private Matrix3f orientation;
    @Nullable
    private Matrix3f renderOrientationO;
    @Nullable
    private Matrix3f renderOrientation;
    @NotNull
    private static final Vector3f FORWARDS = new Vector3f(0.0f, 0.0f, -1.0f);
    @NotNull
    private static final Vector3f UP = new Vector3f(0.0f, 1.0f, 0.0f);
    @NotNull
    private static final Vector3f LEFT = new Vector3f(-1.0f, 0.0f, 0.0f);

    public OrientationController(@NotNull class_1309 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entity = entity;
    }

    @NotNull
    public final class_1309 getEntity() {
        return this.entity;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Nullable
    public final Matrix3f getOrientation() {
        return this.orientation;
    }

    public final boolean isActive() {
        return this.getActive();
    }

    public final void updateOrientation(@NotNull Function1<? super Matrix3f, ? extends Matrix3f> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        if (!this.getActive()) {
            return;
        }
        if (this.orientation == null) {
            this.orientation = new Matrix3f();
            this.rotate(this.entity.method_36454() - (float)180, this.entity.method_36455(), 0.0f);
        }
        Matrix3f matrix3f = this.orientation;
        Intrinsics.checkNotNull((Object)matrix3f);
        this.orientation = (Matrix3f)fn.invoke((Object)matrix3f);
        this.entity.method_36456(this.getYaw());
        this.entity.method_36457(this.getPitch());
    }

    public final void reset() {
        this.orientation = null;
        this.renderOrientationO = null;
        this.renderOrientation = null;
        this.setActive(false);
    }

    public final void rotate(float yaw, float pitch, float roll) {
        this.rotateYaw(yaw);
        this.rotatePitch(pitch);
        this.rotateRoll(roll);
    }

    @NotNull
    public final Quaternionf getRenderOrientation(float delta) {
        Matrix3f matrix3f;
        Matrix3f old;
        Matrix3f matrix3f2 = this.renderOrientationO;
        if (matrix3f2 == null && (matrix3f2 = this.renderOrientation) == null && (matrix3f2 = this.orientation) == null) {
            matrix3f2 = old = new Matrix3f();
        }
        if ((matrix3f = this.renderOrientation) == null) {
            matrix3f = old;
        }
        Matrix3f matrix3f3 = matrix3f;
        Quaternionf oldQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)old);
        Quaternionf newQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)matrix3f3);
        oldQuat.slerp((Quaternionfc)newQuat, delta);
        Intrinsics.checkNotNull((Object)oldQuat);
        return oldQuat;
    }

    public final void tick() {
        if (!this.getActive() || this.orientation == null) {
            return;
        }
        this.renderOrientationO = this.renderOrientation;
        Matrix3f current = this.orientation;
        Matrix3f matrix3f = this.renderOrientation;
        if (matrix3f == null) {
            matrix3f = current;
        }
        Matrix3f renderMatrix = matrix3f;
        Quaternionf renderQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)renderMatrix);
        Quaternionf targetQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)current);
        float dampingFactor = 0.66f;
        renderQuat.slerp((Quaternionfc)targetQuat, dampingFactor);
        Matrix3f newRenderOrientation = new Matrix3f();
        renderQuat.get(newRenderOrientation);
        this.renderOrientation = newRenderOrientation;
    }

    @NotNull
    public final Vector3f getForwardVector() {
        Matrix3f matrix3f = this.orientation;
        if (matrix3f == null || (matrix3f = matrix3f.transform((Vector3fc)FORWARDS, new Vector3f())) == null) {
            matrix3f = new Vector3f((Vector3fc)FORWARDS);
        }
        return matrix3f;
    }

    @NotNull
    public final Vector3f getLeftVector() {
        Matrix3f matrix3f = this.orientation;
        if (matrix3f == null || (matrix3f = matrix3f.transform((Vector3fc)LEFT, new Vector3f())) == null) {
            matrix3f = new Vector3f((Vector3fc)LEFT);
        }
        return matrix3f;
    }

    @NotNull
    public final Vector3f getUpVector() {
        Matrix3f matrix3f = this.orientation;
        if (matrix3f == null || (matrix3f = matrix3f.transform((Vector3fc)UP, new Vector3f())) == null) {
            matrix3f = new Vector3f((Vector3fc)UP);
        }
        return matrix3f;
    }

    public final void rotateYaw(float yaw) {
        this.updateOrientation((Function1<? super Matrix3f, ? extends Matrix3f>)((Function1)arg_0 -> OrientationController.rotateYaw$lambda$0(yaw, arg_0)));
    }

    public final void rotatePitch(float pitch) {
        this.updateOrientation((Function1<? super Matrix3f, ? extends Matrix3f>)((Function1)arg_0 -> OrientationController.rotatePitch$lambda$0(pitch, arg_0)));
    }

    public final void rotateRoll(float roll) {
        this.updateOrientation((Function1<? super Matrix3f, ? extends Matrix3f>)((Function1)arg_0 -> OrientationController.rotateRoll$lambda$0(roll, arg_0)));
    }

    public final float getYaw() {
        return class_3532.method_15393((float)(-AngleExtensionsKt.toDegrees(Float.valueOf(FORWARDS.angleSigned((Vector3fc)this.getForwardVector(), (Vector3fc)UP))) + (float)180));
    }

    public final float getPitch() {
        return class_3532.method_15393((float)(-AngleExtensionsKt.toDegrees(Float.valueOf((float)Math.asin(this.getForwardVector().y)))));
    }

    public final float getRoll() {
        return class_3532.method_15393((float)(-AngleExtensionsKt.toDegrees(Float.valueOf(this.getUpVector().angleSigned((Vector3fc)UP, (Vector3fc)this.getForwardVector())))));
    }

    public final void applyGlobalYaw(float deltaYawDegrees) {
        this.updateOrientation((Function1<? super Matrix3f, ? extends Matrix3f>)((Function1)arg_0 -> OrientationController.applyGlobalYaw$lambda$0(deltaYawDegrees, arg_0)));
    }

    public final void applyGlobalPitch(float deltaPitchDegrees) {
        this.updateOrientation((Function1<? super Matrix3f, ? extends Matrix3f>)((Function1)arg_0 -> OrientationController.applyGlobalPitch$lambda$0(this, deltaPitchDegrees, arg_0)));
    }

    private static final Matrix3f rotateYaw$lambda$0(float $yaw, Matrix3f it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.rotateY(-AngleExtensionsKt.toRadians(Float.valueOf($yaw)));
    }

    private static final Matrix3f rotatePitch$lambda$0(float $pitch, Matrix3f it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.rotateX(-AngleExtensionsKt.toRadians(Float.valueOf($pitch)));
    }

    private static final Matrix3f rotateRoll$lambda$0(float $roll, Matrix3f it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.rotateZ(-AngleExtensionsKt.toRadians(Float.valueOf($roll)));
    }

    private static final Matrix3f applyGlobalYaw$lambda$0(float $deltaYawDegrees, Matrix3f original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return original.rotateLocalY(-AngleExtensionsKt.toRadians(Float.valueOf($deltaYawDegrees)));
    }

    private static final Matrix3f applyGlobalPitch$lambda$0(OrientationController this$0, float $deltaPitchDegrees, Matrix3f original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Quaternionf currQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)original);
        Vector3f horzLeftVector = new Vector3f(0.0f, -Math.abs(Math.signum(this$0.getUpVector().y)), 0.0f).cross((Vector3fc)this$0.getForwardVector());
        Vector3f pitchAxis = (double)horzLeftVector.lengthSquared() < 0.01 ? this$0.getLeftVector() : horzLeftVector;
        Quaternionf globalPitch = new Quaternionf().fromAxisAngleRad((Vector3fc)pitchAxis.normalize(), -AngleExtensionsKt.toRadians(Float.valueOf($deltaPitchDegrees)));
        Quaternionf resultQuat = globalPitch.mul((Quaternionfc)currQuat);
        return new Matrix3f().set((Quaternionfc)resultQuat);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/api/orientation/OrientationController$Companion;", "", "<init>", "()V", "Lorg/joml/Vector3f;", "FORWARDS", "Lorg/joml/Vector3f;", "getFORWARDS", "()Lorg/joml/Vector3f;", "UP", "getUP", "LEFT", "getLEFT", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3f getFORWARDS() {
            return FORWARDS;
        }

        @NotNull
        public final Vector3f getUP() {
            return UP;
        }

        @NotNull
        public final Vector3f getLEFT() {
            return LEFT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

