/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.molang;

import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.struct.QueryStruct;
import com.bedrockk.molang.runtime.struct.VariableStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import com.cobblemon.mod.common.Cobblemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR#\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\"\u0010\"\u001a\u00020\u000b8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\u000b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b(\u0010#R\u0016\u0010)\u001a\u00020\u000b8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b)\u0010#R\u001f\u0010+\u001a\n \u001a*\u0004\u0018\u00010*0*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/cobblemon/mod/common/api/molang/MoLangLoadedFilesCache;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "", "fileName", "Ljava/nio/file/Path;", "validatePath", "(Ljava/lang/String;)Ljava/nio/file/Path;", "", "exists", "(Ljava/lang/String;)Z", "clear", "(Ljava/lang/String;)V", "Lcom/bedrockk/molang/runtime/struct/VariableStruct;", "load", "(Ljava/lang/String;)Lcom/bedrockk/molang/runtime/struct/VariableStruct;", "data", "save", "(Ljava/lang/String;Lcom/bedrockk/molang/runtime/struct/VariableStruct;)V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Ljava/util/concurrent/ConcurrentHashMap;", "loadedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "getLoadedFiles", "()Ljava/util/concurrent/ConcurrentHashMap;", "baseFolder", "Ljava/nio/file/Path;", "getBaseFolder", "()Ljava/nio/file/Path;", "setBaseFolder", "(Ljava/nio/file/Path;)V", "configFolder", "dataFolder", "Lcom/bedrockk/molang/runtime/struct/QueryStruct;", "struct", "Lcom/bedrockk/molang/runtime/struct/QueryStruct;", "getStruct", "()Lcom/bedrockk/molang/runtime/struct/QueryStruct;", "common"})
@SourceDebugExtension(value={"SMAP\nMoLangLoadedFilesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoLangLoadedFilesCache.kt\ncom/cobblemon/mod/common/api/molang/MoLangLoadedFilesCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n72#2,2:115\n1#3:117\n*S KotlinDebug\n*F\n+ 1 MoLangLoadedFilesCache.kt\ncom/cobblemon/mod/common/api/molang/MoLangLoadedFilesCache\n*L\n95#1:115,2\n95#1:117\n*E\n"})
public final class MoLangLoadedFilesCache {
    @NotNull
    public static final MoLangLoadedFilesCache INSTANCE = new MoLangLoadedFilesCache();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @NotNull
    private static final ConcurrentHashMap<String, VariableStruct> loadedFiles = new ConcurrentHashMap();
    public static Path baseFolder;
    private static Path configFolder;
    private static Path dataFolder;
    private static final QueryStruct struct;

    private MoLangLoadedFilesCache() {
    }

    @NotNull
    public final ConcurrentHashMap<String, VariableStruct> getLoadedFiles() {
        return loadedFiles;
    }

    @NotNull
    public final Path getBaseFolder() {
        Path path = baseFolder;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"baseFolder");
        return null;
    }

    public final void setBaseFolder(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        baseFolder = path;
    }

    public final void initialize(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Path path = server.method_27050(class_5218.field_24188);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getWorldPath(...)");
        this.setBaseFolder(path);
        Path path2 = this.getBaseFolder().resolve("config").normalize().toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        configFolder = path2;
        Path path3 = this.getBaseFolder().resolve("data").normalize().toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
        dataFolder = path3;
    }

    public final QueryStruct getStruct() {
        return struct;
    }

    private final Path validatePath(String fileName) {
        Path filePath = this.getBaseFolder().resolve(fileName).normalize().toAbsolutePath();
        Path path = configFolder;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configFolder");
            path = null;
        }
        if (!filePath.startsWith(path)) {
            Path path2 = dataFolder;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataFolder");
                path2 = null;
            }
            if (!filePath.startsWith(path2)) {
                Cobblemon.LOGGER.error("MoLang attempted to access file outside of config or data folder: " + fileName);
                return null;
            }
        }
        if (!StringsKt.contains$default((CharSequence)fileName, (CharSequence)"/molang/", (boolean)false, (int)2, null)) {
            Cobblemon.LOGGER.error("MoLang attempted to access file outside of a 'molang' subfolder: " + fileName);
            return null;
        }
        if (!StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null)) {
            Cobblemon.LOGGER.error("MoLang attempted to access file without a .json extension: " + fileName);
            return null;
        }
        return filePath;
    }

    public final boolean exists(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path path = this.validatePath(fileName);
        if (path == null) {
            return false;
        }
        Path filePath = path;
        return filePath.toFile().exists();
    }

    public final void clear(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        loadedFiles.remove(fileName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final VariableStruct load(@NotNull String fileName) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ConcurrentMap concurrentMap = loadedFiles;
        String key$iv = fileName;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Path path = INSTANCE.validatePath(fileName);
            if (path == null) {
                return new VariableStruct();
            }
            Path filePath = path;
            File file = filePath.toFile();
            if (!file.exists()) {
                return new VariableStruct();
            }
            Intrinsics.checkNotNull((Object)file);
            JsonElement jsonElement = (JsonElement)gson.fromJson(FilesKt.readText$default((File)file, null, (int)1, null), JsonElement.class);
            MoValue moValue = MoValue.of(jsonElement);
            Intrinsics.checkNotNull((Object)moValue, (String)"null cannot be cast to non-null type com.bedrockk.molang.runtime.struct.VariableStruct");
            VariableStruct default$iv = (VariableStruct)moValue;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (VariableStruct)object;
    }

    public final void save(@NotNull String fileName, @NotNull VariableStruct data) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ((Map)loadedFiles).put(fileName, data);
        Path path = this.validatePath(fileName);
        if (path == null) {
            return;
        }
        Path filePath = path;
        File file = filePath.toFile();
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        JsonElement jsonElement = MoValue.writeToJson(data);
        Intrinsics.checkNotNull((Object)file);
        String string = gson.toJson(jsonElement);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
    }

    private static final Object struct$lambda$0(MoParams params) {
        String fileName = params.getParams().get(0).asString();
        Intrinsics.checkNotNull((Object)fileName);
        return INSTANCE.load(fileName);
    }

    private static final Object struct$lambda$1(MoParams params) {
        String fileName = params.getParams().get(0).asString();
        MoValue moValue = params.getParams().get(1);
        Intrinsics.checkNotNull((Object)moValue, (String)"null cannot be cast to non-null type com.bedrockk.molang.runtime.struct.VariableStruct");
        VariableStruct data = (VariableStruct)moValue;
        Intrinsics.checkNotNull((Object)fileName);
        INSTANCE.save(fileName, data);
        return DoubleValue.ONE;
    }

    private static final Object struct$lambda$2(MoParams params) {
        String fileName = params.getParams().get(0).asString();
        Intrinsics.checkNotNull((Object)fileName);
        boolean exists = INSTANCE.exists(fileName);
        return exists ? DoubleValue.ONE : DoubleValue.ZERO;
    }

    private static final Object struct$lambda$3(MoParams params) {
        String fileName = params.getParams().get(0).asString();
        Intrinsics.checkNotNull((Object)fileName);
        INSTANCE.clear(fileName);
        return DoubleValue.ONE;
    }

    static {
        struct = new QueryStruct(new HashMap<String, Function<MoParams, Object>>()).addFunction("load", MoLangLoadedFilesCache::struct$lambda$0).addFunction("save", MoLangLoadedFilesCache::struct$lambda$1).addFunction("exists", MoLangLoadedFilesCache::struct$lambda$2).addFunction("clear", MoLangLoadedFilesCache::struct$lambda$3);
    }
}

