/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.interaction;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.interaction.PlayerActionRequest;
import com.cobblemon.mod.common.api.interaction.ServerPlayerActionRequest;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.TeamManager;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010%\n\u0002\b\u0005\b&\u0018\u0000 :*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001:B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\u000bJ\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000bJ\u001f\u0010\b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\u0010J\u001d\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u000bJ\u001f\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u000bJ\u001f\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0010J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH&\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010\"\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u001e\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\"\u0010#J\u001b\u0010$\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u001e\u001a\u00028\u0000H$\u00a2\u0006\u0004\b$\u0010#J\u0017\u0010&\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0000H\u0004\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u0000H\u0004\u00a2\u0006\u0004\b(\u0010 J!\u0010*\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u00002\b\b\u0002\u0010)\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010,\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b,\u0010'J\u0015\u0010-\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0004\b-\u0010 J\u0017\u0010.\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b.\u0010'J)\u0010/\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b/\u00100J\u0017\u00101\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b1\u0010'J\u0015\u00102\u001a\u00020%2\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0004\b2\u0010'J\u001d\u00102\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b4\u00105R \u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R&\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00108\u00a8\u0006;"}, d2={"Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "T", "", "<init>", "()V", "Ljava/util/UUID;", "senderID", "getOutboundRequest", "(Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "requestID", "(Ljava/util/UUID;Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "receiverID", "getOutboundRequestByRecipient", "Lnet/minecraft/class_3222;", "sender", "(Lnet/minecraft/class_3222;Ljava/util/UUID;)Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;", "", "getInboundRequests", "(Ljava/util/UUID;)Ljava/util/List;", "getInboundRequest", "getInboundRequestBySender", "receiver", "player", "", "isBusy", "(Lnet/minecraft/class_3222;)Z", "target", "isValidInteraction", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;)Z", "request", "canAccept", "(Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;)Z", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "notificationPacket", "(Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;)Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "expirationPacket", "", "addRequest", "(Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;)V", "removeRequest", "expired", "cancelRequest", "(Lcom/cobblemon/mod/common/api/interaction/ServerPlayerActionRequest;Z)V", "onSend", "sendRequest", "onAccept", "acceptRequest", "(Lnet/minecraft/class_3222;Ljava/util/UUID;Lnet/minecraft/class_3222;)Z", "onDecline", "declineRequest", "(Lnet/minecraft/class_3222;Ljava/util/UUID;)V", "onLogoff", "(Lnet/minecraft/class_3222;)V", "", "outboundRequests", "Ljava/util/Map;", "inboundRequests", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nRequestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestManager.kt\ncom/cobblemon/mod/common/api/interaction/RequestManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1#2:231\n1869#3,2:232\n*S KotlinDebug\n*F\n+ 1 RequestManager.kt\ncom/cobblemon/mod/common/api/interaction/RequestManager\n*L\n217#1:232,2\n*E\n"})
public abstract class RequestManager<T extends ServerPlayerActionRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, T> outboundRequests = new LinkedHashMap();
    @NotNull
    private final Map<UUID, List<T>> inboundRequests = new LinkedHashMap();
    @NotNull
    private static final List<RequestManager<?>> managers = new ArrayList();

    @Nullable
    public final T getOutboundRequest(@NotNull UUID senderID) {
        Intrinsics.checkNotNullParameter((Object)senderID, (String)"senderID");
        return (T)((ServerPlayerActionRequest)this.outboundRequests.get(senderID));
    }

    @Nullable
    public final T getOutboundRequest(@NotNull UUID senderID, @NotNull UUID requestID) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)senderID, (String)"senderID");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        T t = this.getOutboundRequest(senderID);
        if (t != null) {
            T t2;
            T it = t2 = t;
            boolean bl = false;
            v1 = Intrinsics.areEqual((Object)((PlayerActionRequest)it).getRequestID(), (Object)requestID) ? t2 : null;
        } else {
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final T getOutboundRequestByRecipient(@NotNull UUID senderID, @NotNull UUID receiverID) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)senderID, (String)"senderID");
        Intrinsics.checkNotNullParameter((Object)receiverID, (String)"receiverID");
        T t = this.getOutboundRequest(senderID);
        if (t != null) {
            T t2;
            T it = t2 = t;
            boolean bl = false;
            v1 = Intrinsics.areEqual((Object)it.getReceiverID(), (Object)receiverID) ? t2 : null;
        } else {
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final T getOutboundRequest(@NotNull class_3222 sender, @NotNull UUID requestID) {
        TeamManager.MultiBattleTeam multiBattleTeam;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
                Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
                multiBattleTeam = TeamManager.INSTANCE.getTeam(sender);
                if (multiBattleTeam == null) break block2;
                TeamManager.MultiBattleTeam it = multiBattleTeam;
                boolean bl = false;
                T t = this.getOutboundRequest(it.getTeamID(), requestID);
                multiBattleTeam = t;
                if (t != null) break block3;
            }
            UUID uUID = sender.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            multiBattleTeam = this.getOutboundRequest(uUID, requestID);
        }
        return (T)multiBattleTeam;
    }

    @Nullable
    public final List<T> getInboundRequests(@NotNull UUID receiverID) {
        Intrinsics.checkNotNullParameter((Object)receiverID, (String)"receiverID");
        return this.inboundRequests.get(receiverID);
    }

    @Nullable
    public final T getInboundRequest(@NotNull UUID receiverID, @NotNull UUID requestID) {
        ServerPlayerActionRequest serverPlayerActionRequest;
        Intrinsics.checkNotNullParameter((Object)receiverID, (String)"receiverID");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        List<T> list = this.getInboundRequests(receiverID);
        if (list != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    ServerPlayerActionRequest it = (ServerPlayerActionRequest)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((PlayerActionRequest)it).getRequestID(), (Object)requestID)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            serverPlayerActionRequest = v1;
        } else {
            serverPlayerActionRequest = null;
        }
        return (T)serverPlayerActionRequest;
    }

    @Nullable
    public final T getInboundRequestBySender(@NotNull UUID receiverID, @NotNull UUID senderID) {
        ServerPlayerActionRequest serverPlayerActionRequest;
        Intrinsics.checkNotNullParameter((Object)receiverID, (String)"receiverID");
        Intrinsics.checkNotNullParameter((Object)senderID, (String)"senderID");
        List<T> list = this.getInboundRequests(receiverID);
        if (list != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    ServerPlayerActionRequest it = (ServerPlayerActionRequest)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSenderID(), (Object)senderID)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            serverPlayerActionRequest = v1;
        } else {
            serverPlayerActionRequest = null;
        }
        return (T)serverPlayerActionRequest;
    }

    @Nullable
    public final T getInboundRequest(@NotNull class_3222 receiver, @NotNull UUID requestID) {
        TeamManager.MultiBattleTeam multiBattleTeam;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
                multiBattleTeam = TeamManager.INSTANCE.getTeam(receiver);
                if (multiBattleTeam == null) break block2;
                TeamManager.MultiBattleTeam it = multiBattleTeam;
                boolean bl = false;
                T t = this.getInboundRequest(it.getTeamID(), requestID);
                multiBattleTeam = t;
                if (t != null) break block3;
            }
            UUID uUID = receiver.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            multiBattleTeam = this.getInboundRequest(uUID, requestID);
        }
        return (T)multiBattleTeam;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBusy(@NotNull class_3222 player) {
        Object t;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (PlayerExtensionsKt.isInBattle(player)) return true;
        if (PlayerExtensionsKt.isTrading(player)) return true;
        Iterable iterable = PlayerExtensionsKt.party(player);
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
            t = iterator.next();
            Pokemon it = (Pokemon)t;
            boolean bl2 = false;
            PokemonEntity pokemonEntity = it.getEntity();
            if (pokemonEntity != null) {
                if (pokemonEntity.isBusy()) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        Object v2 = t;
        if (v2 == null) return false;
        return true;
    }

    public abstract boolean isValidInteraction(@NotNull class_3222 var1, @NotNull class_3222 var2);

    protected abstract boolean canAccept(@NotNull T var1);

    @NotNull
    protected abstract NetworkPacket<?> notificationPacket(@NotNull T var1);

    @NotNull
    protected abstract NetworkPacket<?> expirationPacket(@NotNull T var1);

    protected final void addRequest(@NotNull T request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        this.outboundRequests.put(request.getSenderID(), request);
        this.inboundRequests.computeIfAbsent(request.getReceiverID(), arg_0 -> RequestManager.addRequest$lambda$1(RequestManager::addRequest$lambda$0, arg_0)).add(request);
        request.sendToReceiver(this.notificationPacket(request));
    }

    protected final boolean removeRequest(@NotNull T request) {
        boolean isRemoved;
        boolean removeInbound;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        List<T> inbound = this.inboundRequests.get(request.getReceiverID());
        boolean removeOutbound = this.outboundRequests.remove(request.getSenderID(), request);
        List<T> list = inbound;
        boolean bl = list != null ? list.remove(request) : (removeInbound = false);
        if (removeInbound) {
            List<T> list2 = inbound;
            boolean bl2 = list2 != null ? list2.size() == 0 : false;
            if (bl2) {
                this.inboundRequests.remove(request.getReceiverID(), inbound);
            }
        }
        if (removeInbound != removeOutbound) {
            Cobblemon.LOGGER.error("RequestManager: PlayerActionRequest desync");
        }
        boolean bl3 = isRemoved = removeInbound && removeOutbound;
        if (isRemoved) {
            request.sendToReceiver(this.expirationPacket(request));
        }
        return isRemoved;
    }

    public void cancelRequest(@NotNull T request, boolean expired) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        if (!this.removeRequest(request)) {
            return;
        }
        if (expired) {
            Object[] objectArray = new Object[1];
            class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52502);
            request.notifySender(true, "expired.sender", objectArray);
            objectArray = new Object[1];
            class_5250 class_52503 = request.getSender().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52503);
            request.notifyReceiver(true, "expired.receiver", objectArray);
        } else {
            Object[] objectArray = new Object[1];
            class_5250 class_52504 = request.getReceiver().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52504);
            request.notifySender(true, "canceled.sender", objectArray);
            objectArray = new Object[1];
            class_5250 class_52505 = request.getSender().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52505);
            request.notifyReceiver(true, "canceled.receiver", objectArray);
        }
    }

    public static /* synthetic */ void cancelRequest$default(RequestManager requestManager, ServerPlayerActionRequest serverPlayerActionRequest, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: cancelRequest");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        requestManager.cancelRequest(serverPlayerActionRequest, bl);
    }

    protected void onSend(@NotNull T request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Object[] objectArray = new Object[1];
        class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52502);
        request.notifySender(false, "sent", objectArray);
        objectArray = new Object[1];
        class_5250 class_52503 = request.getSender().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52503);
        request.notifyReceiver(false, "received", objectArray);
    }

    public final boolean sendRequest(@NotNull T request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        T existingRequest = this.getOutboundRequest(request.getSenderID());
        T pendingRequest = this.getInboundRequestBySender(request.getSenderID(), request.getReceiverID());
        if (existingRequest != null && !Intrinsics.areEqual((Object)existingRequest.getReceiverID(), (Object)request.getReceiverID())) {
            RequestManager.cancelRequest$default(this, existingRequest, false, 2, null);
        }
        if (existingRequest != null && Intrinsics.areEqual((Object)existingRequest.getReceiverID(), (Object)request.getReceiverID())) {
            class_3222 class_32222 = request.getSender();
            String string = request.getKey() + ".error.duplicate";
            Object[] objectArray = new Object[1];
            class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52502);
            request.notify(class_32222, true, string, objectArray);
        } else if (pendingRequest != null) {
            class_3222 class_32223 = request.getSender();
            String string = request.getKey() + ".error.pending";
            Object[] objectArray = new Object[1];
            class_5250 class_52503 = request.getReceiver().method_5477().method_27661();
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
            objectArray[0] = TextKt.aqua(class_52503);
            request.notify(class_32223, true, string, objectArray);
        } else if (!this.isValidInteraction(request.getSender(), request.getReceiver())) {
            request.notify(request.getSender(), true, "ui.interact.failed", new Object[0]);
        } else if (this.isBusy(request.getReceiver())) {
            request.notify(request.getSender(), true, "ui.interact.unavailable", new Object[0]);
        } else {
            this.addRequest(request);
            SchedulingFunctionsKt.afterOnServer(((PlayerActionRequest)request).getExpiryTime(), (Function0<Unit>)((Function0)() -> RequestManager.sendRequest$lambda$0(this, request)));
            this.onSend(request);
            return true;
        }
        return false;
    }

    protected void onAccept(@NotNull T request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Object[] objectArray = new Object[1];
        class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52502);
        request.notifySender(false, "accept.sender", objectArray);
        objectArray = new Object[1];
        class_5250 class_52503 = request.getSender().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52503);
        request.notifyReceiver(false, "accept.receiver", objectArray);
    }

    public final boolean acceptRequest(@NotNull class_3222 player, @NotNull UUID requestID, @Nullable class_3222 target) {
        boolean accepted;
        block9: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
            accepted = false;
            T request = this.getInboundRequest(player, requestID);
            if (request == null) {
                class_5250 class_52502 = LocalizationUtilsKt.lang("ui.interact.request_already_expired", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"lang(...)");
                player.method_43502((class_2561)TextKt.red(class_52502), false);
            } else {
                class_3222 class_32222 = target;
                if (class_32222 == null) {
                    class_32222 = request.getSender();
                }
                if (!this.isValidInteraction(player, class_32222)) {
                    request.notify(player, true, "ui.interact.failed", new Object[0]);
                } else if (this.isBusy(request.getSender()) || this.isBusy(request.getReceiver())) {
                    request.notify(player, true, "ui.interact.unavailable", new Object[0]);
                } else if (this.canAccept(request)) {
                    accepted = true;
                }
            }
            T t = request;
            if (t == null) break block9;
            T it = t;
            boolean bl = false;
            this.removeRequest(it);
            if (accepted) {
                this.onAccept(request);
            }
        }
        return accepted;
    }

    public static /* synthetic */ boolean acceptRequest$default(RequestManager requestManager, class_3222 class_32222, UUID uUID, class_3222 class_32223, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: acceptRequest");
        }
        if ((n & 4) != 0) {
            class_32223 = null;
        }
        return requestManager.acceptRequest(class_32222, uUID, class_32223);
    }

    protected void onDecline(@NotNull T request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Object[] objectArray = new Object[1];
        class_5250 class_52502 = request.getReceiver().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52502);
        request.notifySender(true, "decline.sender", objectArray);
        objectArray = new Object[1];
        class_5250 class_52503 = request.getSender().method_5477().method_27661();
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"copy(...)");
        objectArray[0] = TextKt.aqua(class_52503);
        request.notifyReceiver(false, "decline.receiver", objectArray);
    }

    public final void declineRequest(@NotNull T request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        this.removeRequest(request);
        this.onDecline(request);
    }

    public final void declineRequest(@NotNull class_3222 receiver, @NotNull UUID requestID) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)requestID, (String)"requestID");
        T t = this.getInboundRequest(receiver, requestID);
        if (t == null) {
            return;
        }
        T request = t;
        this.declineRequest(request);
    }

    protected void onLogoff(@NotNull class_3222 player) {
        block2: {
            List list;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            ServerPlayerActionRequest serverPlayerActionRequest = (ServerPlayerActionRequest)this.outboundRequests.get(player.method_5667());
            if (serverPlayerActionRequest != null) {
                ServerPlayerActionRequest request = serverPlayerActionRequest;
                boolean bl = false;
                RequestManager.cancelRequest$default(this, request, false, 2, null);
            }
            if ((list = this.inboundRequests.get(player.method_5667())) == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) break block2;
            List requests = list;
            boolean bl = false;
            Iterable $this$forEach$iv = requests;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayerActionRequest request = (ServerPlayerActionRequest)element$iv;
                boolean bl2 = false;
                this.declineRequest(player, ((PlayerActionRequest)request).getRequestID());
            }
        }
    }

    private static final List addRequest$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List addRequest$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Unit sendRequest$lambda$0(RequestManager this$0, ServerPlayerActionRequest $request) {
        this$0.cancelRequest($request, true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/api/interaction/RequestManager$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "manager", "", "register", "(Lcom/cobblemon/mod/common/api/interaction/RequestManager;)Z", "Lnet/minecraft/class_3222;", "player", "", "onLogoff", "(Lnet/minecraft/class_3222;)V", "", "managers", "Ljava/util/List;", "common"})
    @SourceDebugExtension(value={"SMAP\nRequestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestManager.kt\ncom/cobblemon/mod/common/api/interaction/RequestManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1869#2,2:231\n*S KotlinDebug\n*F\n+ 1 RequestManager.kt\ncom/cobblemon/mod/common/api/interaction/RequestManager$Companion\n*L\n228#1:231,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean register(@NotNull RequestManager<?> manager) {
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return managers.add(manager);
        }

        public final void onLogoff(@NotNull class_3222 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$forEach$iv = managers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RequestManager it = (RequestManager)element$iv;
                boolean bl = false;
                it.onLogoff(player);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

